/*
* The contents of this file are subject to the terms
* of the Common Development and Distribution License
* (the License).  You may not use this file except in
* compliance with the License.
*
* You can obtain a copy of the license at
* https://glassfish.dev.java.net/public/CDDLv1.0.html or
* glassfish/bootstrap/legal/CDDLv1.0.txt.
* See the License for the specific language governing
* permissions and limitations under the License.
*
* When distributing Covered Code, include this CDDL
* Header Notice in each file and include the License file
* at glassfish/bootstrap/legal/CDDLv1.0.txt.
* If applicable, add the following below the CDDL Header,
* with the fields enclosed by brackets [] replaced by
* you own identifying information:
* "Portions Copyrighted [year] [name of copyright owner]"
*
* Copyright (c) Ericsson AB, 2004-2007. All rights reserved.
* Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
*/
package org.jvnet.glassfish.comms.admin.monitor;

import com.ericsson.ssa.container.NetworkManager;
import com.ericsson.ssa.container.OLDNetworkManager;
import com.ericsson.ssa.sip.Layer;

import com.sun.enterprise.admin.monitor.stats.CountStatisticImpl;
import com.sun.enterprise.admin.monitor.stats.GenericStatsImpl;
import com.sun.enterprise.admin.monitor.stats.MutableCountStatistic;
import com.sun.enterprise.admin.monitor.stats.MutableCountStatisticImpl;

import javax.management.j2ee.statistics.CountStatistic;
import javax.management.j2ee.statistics.Statistic;


public class NetworkManagerStatsImpl implements NetworkManagerStats, SipStats {
    private MutableCountStatistic invalidSipMessages;
    private MutableCountStatistic receivedSipRequests;
    private MutableCountStatistic receivedSipResponses;
    private MutableCountStatistic sentSipRequests;
    private MutableCountStatistic sentSipResponses;
    private NetworkManager networkManager = null;
    private GenericStatsImpl baseStatsImpl;

    public NetworkManagerStatsImpl() {
        initializeStatistics();
        baseStatsImpl = new GenericStatsImpl(NetworkManagerStats.class, this);
    }

    public void setStatsProvider(Layer provider) {
        this.networkManager = (NetworkManager)provider;
    }

    private void initializeStatistics() {
        CountStatistic c;
        c = new CountStatisticImpl("InvalidSipMessages");
        invalidSipMessages = new MutableCountStatisticImpl(c);

        c = new CountStatisticImpl("ReceivedSipRequests");
        receivedSipRequests = new MutableCountStatisticImpl(c);

        c = new CountStatisticImpl("ReceivedSipResponses");
        receivedSipResponses = new MutableCountStatisticImpl(c);

        c = new CountStatisticImpl("SentSipRequests");
        sentSipRequests = new MutableCountStatisticImpl(c);

        c = new CountStatisticImpl("SentSipResponses");
        sentSipResponses = new MutableCountStatisticImpl(c);
    }

    public long getInvalidSipMessagesLong() {
        if (networkManager instanceof OLDNetworkManager) {
            return ((OLDNetworkManager) networkManager).getEasInvalidSipMessages();
        }

        return 0;
    }

    public long getReceivedSipRequestsLong() {
        if (networkManager instanceof OLDNetworkManager) {
            return ((OLDNetworkManager) networkManager).getEasReceivedSipRequests();
        }

        return 0;
    }

    public long getReceivedSipResponsesLong() {
        if (networkManager instanceof OLDNetworkManager) {
            return ((OLDNetworkManager) networkManager).getEasReceivedSipResponses();
        }

        return 0;
    }

    public long getSentSipRequestsLong() {
        if (networkManager instanceof OLDNetworkManager) {
            return ((OLDNetworkManager) networkManager).getEasSentSipRequests();
        }

        return 0;
    }

    public long getSentSipResponsesLong() {
        if (networkManager instanceof OLDNetworkManager) {
            return ((OLDNetworkManager) networkManager).getEasSentSipResponses();
        }

        return 0;
    }

    public CountStatistic getInvalidSipMessages() {
        invalidSipMessages.setCount((networkManager == null) ? 0
                                                             : getInvalidSipMessagesLong());

        return (CountStatistic) invalidSipMessages.unmodifiableView();
    }

    public CountStatistic getReceivedSipRequests() {
        receivedSipRequests.setCount((networkManager == null) ? 0
                                                              : getReceivedSipRequestsLong());

        return (CountStatistic) receivedSipRequests.unmodifiableView();
    }

    public CountStatistic getReceivedSipResponses() {
        receivedSipResponses.setCount((networkManager == null) ? 0
                                                               : getReceivedSipResponsesLong());

        return (CountStatistic) receivedSipResponses.unmodifiableView();
    }

    public CountStatistic getSentSipRequests() {
        sentSipRequests.setCount((networkManager == null) ? 0
                                                          : getSentSipRequestsLong());

        return (CountStatistic) sentSipRequests.unmodifiableView();
    }

    public CountStatistic getSentSipResponses() {
        sentSipResponses.setCount((networkManager == null) ? 0
                                                           : getSentSipResponsesLong());

        return (CountStatistic) sentSipResponses.unmodifiableView();
    }

    public Statistic getStatistic(String name) {
        return baseStatsImpl.getStatistic(name);
    }

    public String[] getStatisticNames() {
        return baseStatsImpl.getStatisticNames();
    }

    public Statistic[] getStatistics() {
        return baseStatsImpl.getStatistics();
    }

    public Class getInterfaceClass() {
        return NetworkManagerStats.class;
    }
}
