/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright (c) Ericsson AB, 2004-2007. All rights reserved.
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 */

package org.jvnet.glassfish.comms.management.config;

import java.util.Map;

import javax.management.AttributeList;

import com.sun.appserv.management.base.Container;
import com.sun.appserv.management.config.PropertiesAccess;
import com.sun.appserv.management.config.NamedConfigElement;
import com.sun.appserv.management.config.SSLConfigContainer;
import com.sun.appserv.management.config.Enabled;

import org.jvnet.glassfish.comms.admin.management.extensions.SIPXTypes;
/**
     Configuration for an &lt;sip-listener&gt; element.
*/
public interface SIPListenerConfig
    extends PropertiesAccess, NamedConfigElement, SSLConfigContainer, Enabled
{
/** The j2eeType as returned by {@link com.sun.appserv.management.base.AMX#getJ2EEType}. */
    public static final String    J2EE_TYPE    = SIPXTypes.SIP_LISTENER_CONFIG;

    public String    getAddress();
    public void      setAddress( String value );

    public boolean    getEnabled();
    public void       setEnabled( boolean value );

    /**
        The port can be either a number or a system property ${...}, thus its
        type is String.
     */
    public String    getPort();
    public void      setPort( String value );

    public String    getTransport();
    public void      setTransport( String value );

}
