/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright (c) Ericsson AB, 2004-2007. All rights reserved.
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 */

package org.jvnet.glassfish.comms.clb.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jvnet.glassfish.comms.clb.admin.Cluster;
import org.jvnet.glassfish.comms.util.LogUtil;

/**
 *
 * @author kshitiz
 */
public class ClusterHealthMonitorFactory {
    
    private static final HashMap<String, ClusterHealthMonitor> clusterHealthMonitorMap
            = new HashMap<String, ClusterHealthMonitor>();
    
    private static List<String> unusedClusterHealthMonitors = null;
    
    private static final Logger _logger = LogUtil.CLB_LOGGER.getLogger();
    
    /** Creates a new instance of ClusterHealthMonitorFactory */
    public ClusterHealthMonitorFactory() {
    }
    
    public static synchronized void createClusterHealthMonitors(List<Cluster> clusters) throws CLBRuntimeException{
        if(clusters == null || clusters.size() == 0)
            return;
        ArrayList<String> clusterNames = new ArrayList<String>();
        for(Cluster cluster: clusters){
            String clusterName = cluster.getName();
            clusterNames.add(clusterName);
            if(clusterHealthMonitorMap.containsKey(clusterName))
                continue;
            if(_logger.isLoggable(Level.FINE))
                _logger.log(Level.FINE,
                        "clb.creating_cluster_health_monitor_for_cluster",
                        new Object[]{clusterName});
            ClusterHealthMonitor clusterHealthMonitor = new ClusterHealthMonitor(clusterName);
            clusterHealthMonitorMap.put(clusterName, clusterHealthMonitor);
        }
        if(unusedClusterHealthMonitors != null)
            removeUnusedClusterHealthMonitors();
        unusedClusterHealthMonitors = new ArrayList<String>();
        for(String key: clusterHealthMonitorMap.keySet()){
            if(clusterNames.contains(key))
                continue;
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.INFO,
                    "clb.adding_cluster_health_monitor_to_unsed_list",
                    new Object[]{key});
            }
            unusedClusterHealthMonitors.add(key);
        }
        if(unusedClusterHealthMonitors.size() == 0)
            unusedClusterHealthMonitors = null;
    }

    public static synchronized ClusterHealthMonitor get(String clusterName) throws CLBRuntimeException {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE,
                "clb.getting_cluster_health_monitor_for_cluster",
                new Object[]{clusterName});
        }
        ClusterHealthMonitor clusterHealthMonitor = 
                    clusterHealthMonitorMap.get(clusterName);
        if(clusterHealthMonitor == null){
            String message = _logger.getResourceBundle().
                    getString("clb.cluster_health_monitor_does_not_exist") + clusterName;
            throw new CLBRuntimeException(message);
        }
        return clusterHealthMonitor;
    }

    public static synchronized void removeUnusedClusterHealthMonitors() {
        if(unusedClusterHealthMonitors == null)
            return;
        for(String clusterName: unusedClusterHealthMonitors){
            if(_logger.isLoggable(Level.FINE))
                _logger.log(Level.FINE,
                        "clb.removing_cluster_health_monitor_for_cluster",
                        new Object[]{clusterName});
            ClusterHealthMonitor clusterHealthMonitor = 
                    clusterHealthMonitorMap.get(clusterName);
            clusterHealthMonitor.cleanup();
            clusterHealthMonitorMap.remove(clusterName);
        }
        unusedClusterHealthMonitors = null;
    }
}
