/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright (c) Ericsson AB, 2004-2007. All rights reserved.
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 */
package org.jvnet.glassfish.comms.clb.core;


/**
 * This is event listener interface of load-balancer. it handles the cluster membership changes.<br>
 * The cluster membership may change due to following reason<br>
 * <ol>
 * <li>An instance moves to unhealthy state from healthy state</li>
 * <li>An instance moves to healthy state from unhealthy state</li>
 * <li>An instance is enabled</li>
 * <li>An instance is disabled</li>
 * </ol>
 * @author kshitiz
 */
public interface EventListener {
    /**
     * this method handles the event of instance being disabled
     *
     * @param clusterName name of cluster
     * @param instanceName name of instance which is disabled in above mentioned cluster
     */
    public void onDisable(String clusterName, String instanceName);

    /**
     * this method handles the event of instance being enabled
     *
     * @param clusterName name of cluster
     * @param instanceName name of instance which is enabled in above mentioned cluster
     */
    public void onEnable(String clusterName, String instanceName);

    /**
     * this method handles the event of instance becoming healthy
     *
     * @param clusterName name of cluster
     * @param instanceName name of instance which has recovered in above mentioned cluster
     */
    public void onRecovery(String clusterName, String instanceName);

    /**
     * this method handles the event of instance becoming unhealthy
     *
     * @param clusterName name of cluster
     * @param instanceName name of instance which has failed in above mentioned cluster
     */
    public void onFailure(String clusterName, String instanceName);
}
