/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright (c) Ericsson AB, 2004-2007. All rights reserved.
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 */
package org.jvnet.glassfish.comms.clb.core;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.jvnet.glassfish.comms.clb.proxy.http.util.HttpRequest;

import java.util.List;
import org.jvnet.glassfish.comms.util.LogUtil;


/**
 *
 * @author kshitiz
 */
public class StickyRoundRobinRouter extends RoundRobinRouter {
    
    private static final Logger _logger = LogUtil.CLB_LOGGER.getLogger();

    /** Creates a new instance of StickyRoundRobinRouter */
    public StickyRoundRobinRouter(List<ServerCluster> clusters,
        boolean activeRouting) {
        super(clusters, activeRouting);
    }

    public ServerInstance selectInstance(HttpRequest req) {
        String beRoute = StickyBERouteKeyExtractor.getBERouteKey(req);
        ServerInstance instance = null;

        if (beRoute != null) {
            if(_logger.isLoggable(Level.FINE))
                _logger.log(Level.FINE,
                        "clb.found_key_in_request",
                        new Object[]{CLBConstants.BEROUTE_KEY_NAME, beRoute});
            
            //select an instance using BERoute key and assign it to instance
            instance = controller.getGlobalInstanceMap()
                                 .getServerInstance(beRoute);

            if (instance != null) {
                if(_logger.isLoggable(Level.FINE))
                _logger.log(Level.FINE,
                        "clb.instance_found_for_key",
                        new Object[]{instance.getName(), beRoute, instance.isHealthy(),
                        instance.isEnabled(), instance.isQuiesced()});
                /* Need to select another instance from cluster in below cases
                 * 1. Instance is unhealthy
                 * 2. Instance is disabled as well as quiesced
                 */
                if (!instance.isHealthy() ||
                        (instance.isDisabled() && instance.isQuiesced())) {
                    //select another instance from cluster
                    if(_logger.isLoggable(Level.FINE))
                        _logger.log(Level.FINE,
                                "clb.looking_for_instance_in_cluster",
                                new Object[]{instance.getName()});
                    instance = instance.getServerCluster().getClusterRouter()
                                       .selectInstance(req);
                }
            }
        }

        //if no instance is found, select any active instance
        if (instance == null) {
            if(_logger.isLoggable(Level.FINE))
                _logger.log(Level.FINE,
                        "clb.looking_for_active_instance");
            instance = getActiveInstance();
        }

        return instance;
    }
}
