/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright (c) Ericsson AB, 2004-2007. All rights reserved.
 */
package org.jvnet.glassfish.comms.clb.core.common.chr;

import org.jvnet.glassfish.comms.clb.core.ConsistentHashRequest;
import org.jvnet.glassfish.comms.clb.core.RouterFactory;
import org.jvnet.glassfish.comms.clb.core.ServerCluster;

import java.util.List;
import org.jvnet.glassfish.comms.clb.core.ServerInstance;
import org.jvnet.glassfish.comms.clb.core.util.ConsistentHash;


/**
 * This is a router that is based on consistent hashing but uses primarily a
 * {@link StickyHashKeyExtractor} (secondarily the default hash key extraction of the base class {@link ConsistentHashRouter}) to extract the hash key from the request.
 */
public class StickyConsistentHashRouter extends ConsistentHashRouter {
    
    /**
     * Creates an instance.
     * See {@link RouterFactory} for more information about arguments.
     */
    public StickyConsistentHashRouter(List<ServerCluster> associatedClusters,
        boolean activeRouting) {
        super(associatedClusters, activeRouting);
    }
    
    /**
     * Gets the server instance for the specified request.
     *
     * @param req the request
     * @return the server instance for the given hash key
     */
    protected ServerInstance getServerInstance(ConsistentHashRequest req) {
        if (req.getHashKey() == null) {
            return null;
        }

        synchronized (lock) {
            ServerInstance server = null;

            if (!ignoreIdealHash) {
                // First try "ideal" router
                server = idealConsistentHash.get(req.getHashKey());
                assert server != null : "Should always be a value";

                /* Need to select another instance from cluster in below cases
                 * 1. Instance is unhealthy
                 * 2. Instance is disabled as well as quiesced
                 */
                if (!server.isHealthy() ||
                        (server.isDisabled() && server.isQuiesced())) {
                    //select another instance from cluster
                    server = ((ConsistentHashRouter) server.getServerCluster()
                                                           .getClusterRouter()).selectInstance(req);
                }
            }

            if (server == null) {
                server = getActiveInstance(req);
            }

            return server;
        }
    }
}
