/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright (c) Ericsson AB, 2004-2007. All rights reserved.
 */
package org.jvnet.glassfish.comms.clb.core.common.chr.dcr;

import org.w3c.dom.Element;
import org.w3c.dom.Text;

import java.util.regex.Pattern;


public abstract class Operand extends Condition {
    /**
     * Condition types equals; must be an exact match
     */
    public final static int TYPE_EQUALS = 0;

    /**
     * Condition types contains; must be a subset
     */
    public final static int TYPE_CONTAINS = 1;

    /**
     * Condition types exclude; must not contains
     */
    public final static int TYPE_EXCLUDE = 2;

    /**
     * Condition types undefined; must not exists
     */
    public final static int TYPE_UNDEFINED = 3;

    /**
     * Condition types defined; must exists
     */
    public final static int TYPE_DEFINED = 4;
    public final static int TYPE_MATCH = 5;

    /**
     * The string representation of the condition types
     */
    public final static String[] stringConditionType = {
            "equal", "contains", "exclude", "notexist", "exist", "match"
        };

    /**
     *
     */
    private Condition subcondition = null;

    /**
     * The condition type
     *
     * @uml.property name="conditionType"
     */
    protected int conditionType = Integer.MIN_VALUE;

    /**
     * @uml.property name="value"
     */
    protected String value = null;
    protected Pattern matchExpression = null;
    protected String returnCondition = null;

    @Override
    public void addChild(Element element) {
        String nodeName = element.getNodeName();

        // { "equals", "contains", "exclude", "not exist", "exist" };
        if ("equal".equals(nodeName)) {
            value = ((Text) element.getFirstChild()).getData().trim();
            setValue(value);
        } else if ("contains".equals(nodeName)) {
            value = ((Text) element.getFirstChild()).getData().trim();
        } else if ("exclude".equals(nodeName)) {
            value = ((Text) element.getFirstChild()).getData().trim();
            setExclude(value);
        } else if ("notexist".equals(nodeName)) {
            setDefined(false);
        } else if ("exist".equals(nodeName)) {
            setDefined(true);
        } else if ("match".equals(nodeName)) {
            value = ((Text) element.getFirstChild()).getData().trim();
            setMatchExpression(value);
        }
        else if ("if".equals(nodeName)) {
            addSubCondition(element);
        }

        // else if ( "return".equals(nodeName) )
        // {
        // value = ( (Text) element.getFirstChild()).getData().trim();
        // setReturnCondition(value);
        // }
    }

    public void addSubCondition(Element element) {
        Object conditionInstance = element.getUserData("instance");

        if ((conditionInstance != null) &&
                conditionInstance instanceof Condition) {
            subcondition = (Condition) conditionInstance;
        }
    }

    /**
     * @return Returns the conditionType.
     * @uml.property name="conditionType"
     */
    public int getConditionType() {
        return conditionType;
    }

    public Pattern getMatchExpression() {
        return matchExpression;
    }

    public String getReturnCondition() {
        return returnCondition;
    }

    public Condition getSubCondition() {
        return subcondition;
    }

    /**
     * @return Returns the contentValue.
     * @uml.property name="value"
     */
    public String getValue() {
        return value;
    }

    /**
     * @param value The value that the value must contain
     */
    public void setContains(String value) {
        this.value = value;
        this.conditionType = TYPE_CONTAINS;
    }

    /**
     * Set wheter or not this header should be defined
     *
     * @param defined true or false
     */
    public void setDefined(boolean defined) {
        // Ensure that the value is not already defined
        if (conditionType == Integer.MIN_VALUE) {
            if (defined) {
                this.value = "Should exists";
                conditionType = TYPE_DEFINED;
            } else {
                this.value = "Should not exists";
                conditionType = TYPE_UNDEFINED;
            }
        }
    }

    /**
     * Set the value that the value should not contain
     *
     * @param value the value that the header should not contain
     */
    public void setExclude(String value) {
        this.value = value;
        this.conditionType = TYPE_EXCLUDE;
    }

    public void setMatchExpression(String regularExpression) {
        conditionType = TYPE_MATCH;
        matchExpression = Pattern.compile(regularExpression);
    }

    public void setReturnCondition(String returnCondition) {
        this.returnCondition = returnCondition;
    }

    /**
     * @param value The value to set.
     * @uml.property name="value"
     */
    public void setValue(String value) {
        this.value = value;
        this.conditionType = TYPE_EQUALS;
    }
}
