/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright (c) Ericsson AB, 2004-2007. All rights reserved.
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 */
package org.jvnet.glassfish.comms.clb.proxy.config;

import com.sun.enterprise.config.serverbeans.HttpListener;
import com.sun.enterprise.server.ApplicationServer;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.serverbeans.AvailabilityService;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.ConvergedLoadBalancer;
import com.sun.enterprise.config.serverbeans.ServerBeansFactory;
import com.sun.enterprise.config.serverbeans.ServerHelper;
import com.sun.enterprise.server.ServerContext;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;

import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jvnet.glassfish.comms.util.LogUtil;


/**
 *
 * @author
 */
public class ProxyConfig {
    
    /**
     * Used for standalone proxy testing
     */
    // Begin
    private static final String LOCALHOST = "localhost";
    private static final int PORT = 1111;
    public static final String DEFAULT_INSTANCES_LIST =
            "localhost:1111,localhost:1112,localhost:1113";
    private static String addressList = System.getProperty(
            "org.jvnet.glassfish.comms.clb.proxy.instances");
    private static String port = System.getProperty(
            "org.jvnet.glassfish.comms.clb.proxy.localport");
    private static String loglevel = System.getProperty(
            "org.jvnet.glassfish.comms.clb.proxy.loglevel");
    private static String host = System.getProperty(
            "org.jvnet.glassfish.comms.clb.proxy.localhost");
    private int localport = PORT;
    private String localhost = null;
    private InetSocketAddress[] addresses;
    boolean testMode = false;
    // End.
    
    /**
     * Internal strings. Should this be made configurable through domain.xml ?
     */
    /**
     * Portunification finder class property name.
     */
    public final static String SAILFIN_PROXY_PROTOCOL_FINDER =
            "org.jvnet.glassfish.comms.clb.proxy.protocolfinder";
    /**
     * Portunification handler class property name.
     */
    public final static String SAILFIN_PROXY_PROTOCOL_HANDLER =
            "org.jvnet.glassfish.comms.clb.proxy.protocolhandler";
    /**
     * Finder class name.
     */
    public final static String DEFAULT_SAILFIN_PROXY_PROTOCOL_FINDER =
            "org.jvnet.glassfish.comms.clb.proxy.http.LoadBalancerProxyFinder";
    /**
     * Handler class name.
     */
    public final static String DEFAULT_SAILFIN_PROXY_PROTOCOL_HANDLER =
            "org.jvnet.glassfish.comms.clb.proxy.http.LoadBalancerProxyHandler";
    /**
     * Grizzly pipeline class property.
     */
    public static final String PIPELINE_CLASS_PROPERTY =
            "com.sun.enterprise.web.connector.grizzly.pipelineClass";
    /**
     * Sailfin Clb proxy pipeline implementation class.
     */
    public static final String PIPELINE_CLASS =
            "org.jvnet.glassfish.comms.clb.proxy.portunif.SailfinClbProxyPipeline";
    /**
     * Logger instance.
     */
    private static Logger _logger = LogUtil.CLB_LOGGER.getLogger();
    /**
     * Singleton instance.
     */
    private static ProxyConfig _thisInstance = null;
    /**
     * Http request pool size
     */
    private int httpRequestPoolSize = LoadBalancerProxyConstants.HTTP_PAYLOAD_POOL_SIZE;
    
    /**
     * Read timeout.
     */
    private long readtimeout = LoadBalancerProxyConstants.DEFAULT_READ_TIMEOUT;
    
    /**
     * Send retries.
     */
    private int maxsendretries = LoadBalancerProxyConstants.MAX_SEND_RETRY;
    
    
    public ProxyConfig() {
        try {
            if (addressList != null){
                testMode = true;
                setAddresses();
                setLocalHost();
                setLocalPort();
                setLoglevel();
                if (_logger.isLoggable(Level.FINE)){                    
                    _logger.log(Level.FINE,"Initializing proxy in test mode");
                }
                
            } else {
                initialize();
                if (_logger.isLoggable(Level.FINE)){                    
                    _logger.log(Level.FINE,"clb.proxy.config.requestpoolsize.debug"
                            , httpRequestPoolSize);                    
                    _logger.log(Level.FINE,"clb.proxy.config.readtimeout.debug", 
                               readtimeout);                    
                    _logger.log(Level.FINE,"clb.proxy.config.retrycount.debug", 
                            maxsendretries);
                }
            }
        } catch (Exception e) {
            _logger.log(Level.SEVERE,"clb.proxy.config_default", e);
        }
    }
    
    private void initialize(){
        
        ServerContext sc = com.sun.enterprise.server.ondemand.OnDemandServer.getServerContext();
        ConfigContext instanceConfigContext = sc.getConfigContext();
        
        
        Config instanceConfig = null;
        com.sun.enterprise.config.serverbeans.Proxy proxy  = null;
        try {
            instanceConfig = ServerBeansFactory.getConfigBean(instanceConfigContext);
            proxy = instanceConfig.getAvailabilityService().
                    getConvergedLoadBalancer().getProxy();
        } catch (ConfigException ex) {
            _logger.log(Level.SEVERE,"clb.proxy.config_default", ex);
            return;
        }
        if (proxy == null) {
            _logger.log(Level.SEVERE,"clb.proxy.config_bad_proxy");
            return;
        }
        httpRequestPoolSize = Integer.parseInt(proxy.getRequestPoolSize());
        readtimeout = Long.parseLong(proxy.getReadTimeoutInMillis());
        maxsendretries = Integer.parseInt(proxy.getSendRetryCount());
        if (_logger.isLoggable(Level.FINE)){
            _logger.log(Level.FINE, " HttpProxy Request pool size " + 
                    httpRequestPoolSize);
            _logger.log(Level.FINE, " HttpProxy Read time out " + 
                    readtimeout);
            _logger.log(Level.FINE, " HttpProxy max retries " + 
                    maxsendretries);
        }
        
    }
    
    public long getReadTimeOut(){
        return readtimeout;
    }
    
    public int getReadTimeOutInt(){
        return (new Long(readtimeout/1000)).intValue();
    }
    
    public int getSendRetryCount(){
        return maxsendretries;
    }
    
    public int getRequestPoolSize(){
        return httpRequestPoolSize;
    }
    
    /**
     * Singleton method to get this instance.
     */
    public static synchronized ProxyConfig getInstance() {
        if (_thisInstance == null) {
            _thisInstance = new ProxyConfig();
        }
        
        return _thisInstance;
    }
    
    public boolean isTestMode(){
        return testMode;
    }
    /**
     * Singleton object, so ensure nobody clones this.
     */
    @Override
    public Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }
    
    public Logger getLogger() {
        return _logger;
    }
    
    private void setLoglevel() {
        Level level = Level.parse(LoadBalancerProxyConstants.DEFAULT_LOG_LEVEL);
        try {
            level = Level.parse(loglevel);
            _logger.setLevel(level);
        } catch (Exception e) {
            ;
        }
    }
    
    private void setLocalHost() {
        localhost = "localhost";
        
        try {
            localhost = InetAddress.getLocalHost().toString();
        } catch (UnknownHostException ex) {
            ex.printStackTrace();
        }
    }
    
    public String getLocalHost() {
        return localhost;
    }
    
    public InetSocketAddress[] getAddresses() {
        return addresses;
    }
    
    public void setAddresses() {
        String list = (addressList == null) ? DEFAULT_INSTANCES_LIST
                : addressList;
        StringTokenizer tokenizer = new StringTokenizer(list, ",");
        addresses = new InetSocketAddress[tokenizer.countTokens()];
        
        int counter = 0;
        
        while (tokenizer.hasMoreTokens()) {
            String add = tokenizer.nextToken();
            int colonindex = add.indexOf(":");
            String hostname = add.substring(0, colonindex);
            int iport = PORT;
            
            if (colonindex != -1) {
                String xport = add.substring(colonindex + 1);
                
                try {
                    iport = Integer.parseInt(xport);
                } catch (Exception e) {
                    _logger.log(Level.SEVERE,"clb.proxy.invalid.port");
                    iport = PORT;
                }
            }
            
            InetSocketAddress inet = new InetSocketAddress(hostname, iport);
            addresses[counter++] = inet;
        }
    }
    
    private void setLocalPort() {
        localport = PORT;
        try {
            localport = Integer.parseInt(port);
        } catch (Exception e) {
            ;
        }
    }
    
    public int getLocalPort() {
        return localport;
    }
    
    public static String getAdminPort() {
        String sn = ApplicationServer.getServerContext().getInstanceName();
        ConfigContext cc = ApplicationServer.getServerContext()
        .getConfigContext();
        HttpListener admin = null;
        
        try {
            admin = ServerHelper.getHttpListener(cc, sn,
                    ServerHelper.ADMIN_HTTP_LISTNER_ID);
        } catch (ConfigException ex) {
            ex.printStackTrace();
        }
        
        String port = null;
        
        if (admin != null) {
            port = admin.getPort();
        }
        
        return port;
    }
    
    public static String getAdminInet() {
        String sn = ApplicationServer.getServerContext().getInstanceName();
        ConfigContext cc = ApplicationServer.getServerContext()
        .getConfigContext();
        HttpListener admin = null;
        
        try {
            admin = ServerHelper.getHttpListener(cc, sn,
                    ServerHelper.ADMIN_HTTP_LISTNER_ID);
        } catch (ConfigException ex) {
            ex.printStackTrace();
        }
        
        String address = null;
        
        if (admin != null) {
            address = admin.getAddress();
        }
        
        return address;
    }
}
