/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright (c) Ericsson AB, 2004-2007. All rights reserved.
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 */
package org.jvnet.glassfish.comms.clb.proxy.http;

import com.sun.enterprise.web.portunif.*;
import com.sun.enterprise.web.portunif.util.ProtocolInfo;

import org.jvnet.glassfish.comms.clb.proxy.ProxyRequestHandler;
import org.jvnet.glassfish.comms.clb.proxy.api.Endpoint;
import org.jvnet.glassfish.comms.clb.proxy.config.ProxyConfig;
import org.jvnet.glassfish.comms.clb.proxy.http.util.ObjectManager;
import org.jvnet.glassfish.comms.clb.proxy.portunif.SailfinClbProxyProtocolInfo;

import java.io.IOException;

import java.util.logging.Level;
import java.util.logging.Logger;


/**
 * A <code>ProtocolFinder</code> implementation that parse the available
 * SocketChannel bytes looking for the 'http' bytes.
 *
 * @author
 */
public class LoadBalancerProxyFinder extends HttpProtocolFinder {
    private Logger _logger = null;
    private ObjectManager objManager;
    private TlsProtocolFinder tlsfinder;
    
    public LoadBalancerProxyFinder() {
        objManager = ObjectManager.getInstance();
        objManager.initialize();
        _logger = ProxyConfig.getInstance().getLogger();
        tlsfinder = new TlsProtocolFinder();
    }
    
    /**
     * Try to find if the current connection is using the HTTP protocol.
     * Also if the protocol is Http, this class determines if the
     * request has to be served by the local web container or by a remote
     * instance.
     *
     * @param ProtocolInfo The ProtocolInfo that contains the information
     *                      about the current protocol.
     */
    public void find(ProtocolInfo protocolInfo) {
        if (_logger.isLoggable(Level.FINE)){
            _logger.log(Level.FINE, "clb.proxy.http.finder_invoked");
        }
        if (protocolInfo.isRequestedTransportSecure) {
            try {
                tlsfinder.find(protocolInfo);
            } catch (IOException ex) {
                _logger.log(Level.SEVERE,"clb.proxy.http.finder_tls_exception", ex);
            }
        }
        super.find(protocolInfo);
        if (protocolInfo.protocol != null) {
            if (protocolInfo.protocol.equals("http") ||
                    protocolInfo.protocol.equals("https")) {
                if (isRemoteTermination(protocolInfo)) {
                    protocolInfo.protocol = protocolInfo.isSecure ? "lb/https"
                            : "lb/http";
                }
            }
        }
        _logger.log(Level.INFO,
                "clb.proxy.finder_result",""  + protocolInfo.protocol);
    }
    
    private boolean isRemoteTermination(ProtocolInfo protocolInfo) {
        try {
            if (_logger.isLoggable(Level.FINE)){
                _logger.log(Level.FINE,"clb.proxy.polling_task");
            }
            ProxyRequestHandler task = objManager.pollTask(protocolInfo.isSecure);
            if (_logger.isLoggable(Level.FINE)){
                _logger.log(Level.FINE,"clb.proxy.polled_task", "" + task);
            }
            task.setByteBuffer(protocolInfo.byteBuffer);
            task.setSelectionKey(protocolInfo.key);
            task.setSecure(protocolInfo.isSecure);
            task.setSSLEngine(protocolInfo.sslEngine);
            task.setOutputBB(protocolInfo.outputBB);
            task.doTask();
            protocolInfo.inputBB = task.getBuffer();
            protocolInfo.bytesRead = task.getBuffer().position();
            protocolInfo.byteBuffer = task.getBuffer();
            Endpoint remoteHost = task.getEndpoint();
            
            if ((remoteHost != null) && remoteHost.isLocal()) {
                _logger.log(Level.INFO, "clb.proxy.request_local");
                task.recycle();
                objManager.offerTask(task, protocolInfo.isSecure);
                
                return false;
            } else {
                _logger.log(Level.INFO, "clb.proxy.request_remote");
            }
            if (_logger.isLoggable(Level.FINE)){
                _logger.log(Level.FINE,
                        "clb.proxy.http.protocolinfo_bytes_read","" + protocolInfo.bytesRead);
                _logger.log(Level.FINE, "clb.proxy.requesthandler.payload_length", "" +
                        task.getPayloadLength());

            }
            ((SailfinClbProxyProtocolInfo) protocolInfo).object = task;
        } catch (Exception e) {
            e.printStackTrace();
        }
        
        return true;
    }
}
