/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright (c) Ericsson AB, 2004-2007. All rights reserved.
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 */
package org.jvnet.glassfish.comms.clb.proxy.http.layers;

import com.sun.grizzly.tcp.Request;
import com.sun.grizzly.tcp.Response;

import org.jvnet.glassfish.comms.clb.proxy.DefaultEndpoint;
import org.jvnet.glassfish.comms.clb.proxy.api.Endpoint;
import org.jvnet.glassfish.comms.clb.proxy.config.LoadBalancerProxyConstants;
import org.jvnet.glassfish.comms.clb.proxy.config.ProxyConfig;
import org.jvnet.glassfish.comms.clb.proxy.config.RoundRobinPolicy;
import org.jvnet.glassfish.comms.clb.proxy.http.util.HttpRequest;
import org.jvnet.glassfish.comms.httplayers.HttpLayer;


import java.net.InetSocketAddress;

import java.util.logging.Level;
import java.util.logging.Logger;


/**
 * This class is used for standalone testing of proxy. This is not meant for
 * use in production.
 *
 * @author rampsarathy
 */
public class LoadBalancerLayer implements HttpLayer {
    Logger _logger = null;
    
    /** Creates a new instance of LoadBalancerLayer */
    public LoadBalancerLayer() {
        _logger = ProxyConfig.getInstance().getLogger();
    }
    
    public boolean invoke(Request request, Response response)
    throws Exception {
        if (_logger.isLoggable(Level.FINE)){
            _logger.log(Level.FINE, "clb.proxy.test.loadbalancerlayer_begin");
        }
        HttpRequest httpReq = (HttpRequest) request;
        Endpoint remoteEndpoint = null;
        boolean ret = true;
        if (request.getHeader("ERRORTEST") != null) {
            response.setHeader("TESTHEADER", "ProxyTest");
            response.setErrorURI("testurl");
            response.setStatus(500);
            response.setMessage("Internal Server Error");
            _logger.log(Level.INFO, "clb.proxy.test.error_response");
            return false;
        }
        if ((httpReq.getHeader(LoadBalancerProxyConstants.HTTP_PROXY_HEADER) != null)) {
            Endpoint ep = new DefaultEndpoint();
            ep.setLocal(true);
            httpReq.setConvergedLoadBalancerEndpoint(ep);
            return false;
        }
        InetSocketAddress remoteHost = RoundRobinPolicy.getInetSocketAddress(request);
        if (_logger.isLoggable(Level.FINE)){
            _logger.log(Level.FINE,"clb.proxy.test.remote_host", remoteHost);
        }
        if (remoteHost.getAddress().isLoopbackAddress() &&
                (remoteHost.getPort() == ProxyConfig.getInstance().getLocalPort())) {
            remoteEndpoint = new DefaultEndpoint();
            remoteEndpoint.setLocal(true);
            
            ret = false;
        } else {
            remoteEndpoint = new DefaultEndpoint(remoteHost);
            httpReq.addHeader(LoadBalancerProxyConstants.HTTP_PROXY_HEADER,
                    remoteHost.getAddress().toString());
        }
        
        if (_logger.isLoggable(Level.FINE)) {
            httpReq.dump();
        }        
        httpReq.setConvergedLoadBalancerEndpoint(remoteEndpoint);
        if (_logger.isLoggable(Level.FINE)){
            _logger.log(Level.FINE, "clb.proxy.test.loadbalancerlayer_end");
        }
        return ret;
    }
}
