/*
* The contents of this file are subject to the terms
* of the Common Development and Distribution License
* (the License).  You may not use this file except in
* compliance with the License.
*
* You can obtain a copy of the license at
* https://glassfish.dev.java.net/public/CDDLv1.0.html or
* glassfish/bootstrap/legal/CDDLv1.0.txt.
* See the License for the specific language governing
* permissions and limitations under the License.
*
* When distributing Covered Code, include this CDDL
* Header Notice in each file and include the License file
* at glassfish/bootstrap/legal/CDDLv1.0.txt.
* If applicable, add the following below the CDDL Header,
* with the fields enclosed by brackets [] replaced by
* you own identifying information:
* "Portions Copyrighted [year] [name of copyright owner]"
*
* Copyright (c) Ericsson AB, 2004-2007. All rights reserved.
* Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
*/
package org.jvnet.glassfish.comms.startup.lifecycle;

import com.sun.appserv.server.LifecycleEvent;
import com.sun.appserv.server.LifecycleEventContext;
import com.sun.appserv.server.LifecycleListener;
import com.sun.appserv.server.ServerLifecycleException;

import com.sun.enterprise.deployment.pluggable.PluggableDeploymentInfo;
import com.sun.enterprise.deployment.pluggable.PluggableNodeInfo;

import com.sun.org.apache.commons.digester.Digester;

import org.jvnet.glassfish.comms.httplayers.HttpLayerHandler;
import org.jvnet.glassfish.comms.util.LogUtil;
import org.jvnet.glassfish.comms.util.LogUtil;

import java.io.InputStream;

import java.lang.reflect.Method;

import java.util.ArrayList;
import java.util.Collection;


/**
 * This class represents the lifecycle listener for the SipContainer lifecycle
 * module. This module is defined as a lifecycle-module in the domain.xml and
 * would be used to do the required initialization for Sailfin
 * @author Prasad Subramanian
 */
public class SipContainerLifecycle implements LifecycleListener {
    private LogUtil logger = new LogUtil(getClass());

    /**
     *  Handles the event and delegates to methods for each event type
     *  @param  event the LifecycleEvent
     *  @throws ServerLifecycleException
     */
    public void handleEvent(LifecycleEvent event)
        throws ServerLifecycleException {
        LifecycleEventContext ctx = event.getLifecycleEventContext();
        ctx.log("got event" + event.getEventType() + " event data: " +
            event.getData());

        switch (event.getEventType()) {
        case LifecycleEvent.INIT_EVENT:
            onInitialization(ctx);

            break;

        case LifecycleEvent.STARTUP_EVENT:
            onStartup(ctx);

            break;

        case LifecycleEvent.READY_EVENT:
            onReady(ctx);

            break;

        case LifecycleEvent.SHUTDOWN_EVENT:
            onShutdown();

            break;

        case LifecycleEvent.TERMINATION_EVENT:
            onTermination();

            break;
        }
    }

    /**
     *  Method to handle the INIT_EVENT
     */
    public void onInitialization(LifecycleEventContext sc)
        throws ServerLifecycleException {
        logger.infoMsg("SipLifecycleListener: In the OnInitialization method");
        // do the registration of Deployer
        registerExtensionDeployer();
        registerExtensionNodes();

        // Create basic layers
        InputStream is = getClass().getResourceAsStream("dispatcher.xml");
        HttpLayerHandler.getInstance().parse(is);

        initClbAdmin();
    }

    /**
     *  Method to handle the START_EVENT
     */
    public void onStartup(LifecycleEventContext sc)
        throws ServerLifecycleException {
    }

    /**
     *  Method to handle the READY_EVENT
     */
    public void onReady(LifecycleEventContext sc)
        throws ServerLifecycleException {
    }

    /**
     *  Method to handle the SHUTDOWN_EVENT
     */
    public void onShutdown() throws ServerLifecycleException {
    }

    /**
     *  Method to handle the TERMINATION_EVENT
     */
    public void onTermination() throws ServerLifecycleException {
    }

    public void registerExtensionDeployer() {
        //register the SipArchiveDeployer for Sip ARchives
        try {
        	 String AR_DEPLOYER = 
                 "org.jvnet.glassfish.comms.deployment.backend.ArArchiveDeployer";
             String AR_LOADER = 
                 "org.jvnet.glassfish.comms.deployment.backend.ArArchiveLoader";
             
             logger.infoMsg("Registering the " + AR_DEPLOYER);
             logger.infoMsg("Registering the " + AR_LOADER);
             PluggableDeploymentInfo.registerArchiveDeployerLoader(
         		AR_DEPLOYER, AR_LOADER);
             
            String SIP_DEPLOYER = "org.jvnet.glassfish.comms.deployment.backend.SipArchiveDeployer";
            String SIP_LOADER = "org.jvnet.glassfish.comms.deployment.backend.SipArchiveLoader";
            PluggableDeploymentInfo.registerArchiveDeployerLoader(SIP_DEPLOYER,
                SIP_LOADER);
            logger.infoMsg("Registering the " + SIP_DEPLOYER);
            logger.infoMsg("Registering the " + SIP_LOADER);
            
        } catch (ServerLifecycleException sle) {
            logger.infoMsg("ServerLifecyleException thrown :");
        } catch (java.lang.Exception e) {
            e.printStackTrace();
        }
    }

    public void initClbAdmin() {
        try {
            Class cls = Class.forName(
                    "org.jvnet.glassfish.comms.admin.clbadmin.ClbAdmin");
            Method m = cls.getMethod("init");
            m.invoke(cls.newInstance());
        } catch (Exception e) {
        }
    }

    public void registerExtensionNodes() {
        String SCAS_RUNTIME_TAG = "sun-sip-app";
        String SCAS_RUNTIME_NODE_CLASS = "org.jvnet.glassfish.comms.deployment.runtime.sip.SipBundleRuntimeNode";

        PluggableNodeInfo.registerBundleNode(SCAS_RUNTIME_TAG,
            SCAS_RUNTIME_NODE_CLASS);

        logger.infoMsg("Registering the " + SCAS_RUNTIME_TAG);
        logger.infoMsg("Registering the " + SCAS_RUNTIME_NODE_CLASS);
    }
}
