package org.jvnet.glassfish.comms.deployment.backend;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.logging.Level;

import javax.enterprise.deploy.shared.ModuleType;

import org.jvnet.glassfish.comms.util.LogUtil;

import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.backend.J2EEModuleExploder;
import com.sun.enterprise.deployment.deploy.shared.AbstractArchive;
import com.sun.enterprise.deployment.interfaces.pluggable.ArchiveDeployer;
import com.sun.enterprise.deployment.interfaces.pluggable.ArchiveDescriptor;
import com.sun.enterprise.deployment.io.DeploymentDescriptorFile;
import com.sun.enterprise.deployment.util.XModuleType;

public class ArArchiveDeployer
	implements ArchiveDeployer {

	private static LogUtil theirLog = new LogUtil(LogUtil.SIP_LOG_DOMAIN);
	private static final String LOGPREFIX = 
		"org.jvnet.glassfish.comms.deployment.backend.ArArchiveDeployer.";
	
	private String arClassName = "";
	private ModuleType moduleType = XModuleType.getModuleType(this.getClass()
			.getName());

	
	
	public void cleanup(File moduleRootDirectory) throws Exception {
		if (theirLog.isLoggable(Level.FINEST)) {
			theirLog.log(Level.FINEST, LOGPREFIX + "cleanup");
		}
	}

	public void expand(File archivePath, File moduleRootDirectory)
			throws Exception {
		if (theirLog.isLoggable(Level.FINEST)) {
			theirLog.log(Level.FINEST, LOGPREFIX + "expanding_archive",
					archivePath, moduleRootDirectory);
		}

		// expand stuff in the File archivePath to the moduleRootDirectory,
		// in particular the class implementing ApplicationRouterInfo
		J2EEModuleExploder.explodeJar(archivePath, moduleRootDirectory);
	}

	public DeploymentDescriptorFile getConfigurationDDFile() {
		if (theirLog.isLoggable(Level.FINEST)) {
			theirLog.log(Level.FINEST,
					"----- getConfigurationDDFile(): null ----");
		}
		return null;
	}

	public Descriptor getDefaultBundleDescriptor() {
		if (theirLog.isLoggable(Level.FINEST)) {
			theirLog.log(Level.FINEST,
					"----- getDefaultBundleDescriptor(): null ----");
		}
		return null;
	}

	public Descriptor getDescriptor() {
		if (theirLog.isLoggable(Level.FINEST)) {
			theirLog.log(Level.FINEST, "----- getDescriptor(): null ----");
		}
		return null;
	}

	public String getModuleDescription() {
		if (theirLog.isLoggable(Level.FINEST)) {
			theirLog.log(Level.FINEST,
					"----- getModuleDescription(): null ----");
		}
		return null;
	}

	public ModuleType getModuleType() {
		if (theirLog.isLoggable(Level.FINEST)) {
			theirLog.log(Level.FINEST, LOGPREFIX + "moduletype_retrieved",
					moduleType, moduleType.getModuleExtension(), moduleType
							.getValue());
		}
		return moduleType;
	}

	public DeploymentDescriptorFile getStandardDDFile() {
		if (theirLog.isLoggable(Level.FINEST)) {
			theirLog.log(Level.FINEST, "----- getStandardDDFile(): null ----");
		}
		return null;
	}

	/**
	 * Returns true if the archive under investigation is an Application Router
	 * archive. The deployer will look in the archive and determine if the 
	 * Manifest.MF specifies the class name of the AR to load. The attribute that
	 * should be specified is:
	 * 
	 * "Application-Router-Class"
	 * 
	 * The specified value should point to a valid FDN of a class implementing 
	 * the ApplicationRouter interface.
	 * 
	 * @see com.sun.enterprise.deployment.interfaces.pluggable.ArchiveDeployer#handles(com.sun.enterprise.deployment.deploy.shared.AbstractArchive)
	 */
	public boolean handles(AbstractArchive archiveFile) {
		if (theirLog.isLoggable(Level.FINEST)) {
			theirLog.log(Level.FINEST, LOGPREFIX + "handling_archive",
					archiveFile);
		}
		// We will handle if the archiveFile contains some
		// class files implementing the ApplicationRouter interface

		// For now we look at the Manifest.
		try {
			Manifest m = archiveFile.getManifest();
                        if(m != null ) { 
			    m.getMainAttributes();
			    Attributes attrs = m.getMainAttributes();
		            String rc = attrs.getValue("Application-Router-Class");
			
			    if (rc != null && !("".equals(rc))) {
				if (theirLog.isLoggable(Level.FINEST)) {
					theirLog.log(Level.FINEST, LOGPREFIX + "archive_handled");
				}
				arClassName = rc;
				return true;
			    } else {
				if (theirLog.isLoggable(Level.FINEST)) {
					theirLog.log(Level.FINEST, LOGPREFIX
							+ "archive_not_handled");
				}
				return false;
			    }
                        } else {
                           return false;
                        }
		} catch (IOException ioe) {
			ioe.printStackTrace();
			theirLog.severe(ioe.toString());
			return false;
		}
	}

	public ArchiveDescriptor prepare(File moduleRootDirectory,
			File moduleScratchDirectory, ClassLoader parentClassLoader,
			boolean isStartup) throws Exception {
		if (theirLog.isLoggable(Level.FINEST)) {
			theirLog.log(Level.FINEST, "----- prepare() -----");
			theirLog.log(Level.FINEST, "----- moduleRootDirectory: "
					+ moduleRootDirectory);
			theirLog.log(Level.FINEST, "----- moduleScratchDirectory: "
					+ moduleScratchDirectory);
			theirLog.log(Level.FINEST, "----- parentClassLoader: "
					+ parentClassLoader);
			theirLog.log(Level.FINEST, "----- isStartup: " + isStartup);
		}

		// at this point, expand has already been called,
		// so now prepare an ArchiveDescriptor
		ArArchiveDescriptor descriptor = new ArArchiveDescriptor();
		URL moduleURL = moduleRootDirectory.toURL();
		URLClassLoader loader = new URLClassLoader(new URL[] { moduleURL },
				parentClassLoader);
		descriptor.setModuleClassLoader(loader);

		String arNoteBook = 
			moduleScratchDirectory.getAbsolutePath() + 
			File.separator + "arNoteBook.txt";
		
		// was arClassName set during a call to handles() ?
		if ("".equals(arClassName)){
			// no, then try to recover it from the notebook
			try {
				BufferedReader in = new BufferedReader(
					new FileReader(arNoteBook));
				arClassName = in.readLine();
				theirLog.log(Level.FINEST, "arClassName retrieved from scratch dir: " + arClassName);
				in.close();
			}
			catch (IOException e){
				theirLog.severe(e, LOGPREFIX + "arclass_not_set");
				throw new Exception(
					"Could not prepare archive, missing AR class name", e);
			}
		}
		else {
			// store arClassName in the moduleScratchDirectory
			// where it can be retrieved after a server restart
			try {
				// first delete any garbage
				File oldNoteBook = new File(arNoteBook);
				if (oldNoteBook.exists()){
					oldNoteBook.delete();
				}
				// now create the new file
				BufferedWriter out = new BufferedWriter(
					new FileWriter(arNoteBook));
				out.write(arClassName);
				out.close();
			}
			catch (IOException e){
				// report error, AR will not be available after
				// server restart.
				theirLog.severe(e, "Could not store arClassName in tmp file");
			}
		}
		// set the arClassname in the descriptor so the loader can create an AR
		descriptor.setApplicationRouterClass(arClassName);
		return descriptor;	
	}

	public void setDescriptor(Descriptor descriptor) {
		if (theirLog.isLoggable(Level.FINEST)) {
			theirLog.log(Level.FINEST, "----- setDescriptor() -----");
		}
	}
}
