/*
* The contents of this file are subject to the terms
* of the Common Development and Distribution License
* (the License).  You may not use this file except in
* compliance with the License.
*
* You can obtain a copy of the license at
* https://glassfish.dev.java.net/public/CDDLv1.0.html or
* glassfish/bootstrap/legal/CDDLv1.0.txt.
* See the License for the specific language governing
* permissions and limitations under the License.
*
* When distributing Covered Code, include this CDDL
* Header Notice in each file and include the License file
* at glassfish/bootstrap/legal/CDDLv1.0.txt.
* If applicable, add the following below the CDDL Header,
* with the fields enclosed by brackets [] replaced by
* you own identifying information:
* "Portions Copyrighted [year] [name of copyright owner]"
*
* Copyright (c) Ericsson AB, 2004-2007. All rights reserved.
* Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
*/

/*
 * SipArchiveLoader.java
 *
 * Created on July 26, 2007, 2:20 PM
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */
package org.jvnet.glassfish.comms.deployment.backend;

import com.sun.enterprise.deployment.interfaces.pluggable.ArchiveDescriptor;
import com.sun.enterprise.deployment.interfaces.pluggable.ArchiveLoader;
import com.sun.enterprise.server.WebArchiveLoader;

import org.jvnet.glassfish.comms.deployment.backend.SipBundleDescriptor;


/**
 * <p>This class is the loader class for SIP Applications ( both pure as well as
 * Converged HTTP+SIP ).
 * An instance of this class is registered with the ExtensionModuleDeployer for
 * the module Type that represents SIP Applications. The ExtensionModuleLoader
 * retrives an instance of this class from the ExtensionModuleDeployer and calls
 * the load/unload methods. </p>
 *
 * <p> This class extends the WebArchiveLoader class which is a wrapper class
 * abstracting the load/unload functionality of the WebContainer
 * </p>
 *
 *
 * @author prasad.subramanian@sun.com
 */
public class SipArchiveLoader extends WebArchiveLoader implements ArchiveLoader {
    /**
     * This method implements the load method from the ArchiveLoader. Loads
     * standalone extension modules, extension modules within a .ear
     *  also enables these modules
     * @param descriptor the descriptor for the module to be loaded
     * @param isEnable a flag to enable the module
     * @return boolean true for success
     * @throws Exception
     */
    public boolean load(ArchiveDescriptor descriptor, boolean isEnableAction)
        throws Exception {
        // check if the module is a part of an application
        // FIX : Is this the best wayto check if this module is part of
        // an ear         
        if (getJ2eeAppBean() != null) {
            if (!isEnableAction) {
                return loadJ2eeApplicationModule(descriptor);
            } else {
                //add method to enable modules                
            }
        } else {
            String modId = ((SipBundleDescriptor) descriptor).getName();

            if (isEnableAction) {
                return enableWebModule(getModuleConfig(getExtensionModule(modId),
                        (SipBundleDescriptor) descriptor));
            } else {
                // create the WebModuleConfig object and call the 
                // loadWebModule method
                return loadWebModule(getModuleConfig(getExtensionModule(modId),
                        (SipBundleDescriptor) descriptor));
            }
        }

        return true;
    }

    /**
     * This method implements the unload method from the ArchiveLoader. Unloads
     * standalone extension modules, extension modules within a .ear
     *  also disables these modules
     * @param descriptor the descriptor for the module to be loaded
     * @param isDisable a flag to disable the module
     * @return boolean true for success
     * @throws Exception
     */
    public boolean unload(ArchiveDescriptor descriptor, boolean isDisableAction)
        throws Exception {
        // check if the module is a part of an application
        // FIX : Is this the best wayto check if this module is part of
        // an ear 
        if (getJ2eeAppBean() != null) {
            if (!isDisableAction) {
                return unloadJ2eeApplicationModule((SipBundleDescriptor) descriptor);
            } else {
                //add method to disable modules                
            }
        } else {
            String modId = ((SipBundleDescriptor) descriptor).getName();

            if (isDisableAction) {
                return disableWebModule(getExtensionModule(modId));
            } else {
                // Call the unloadWebModule.
                // This method would contruct the parameters
                // needed to call the unloadWebModule method on the WebContainer
                return unloadWebModule(getExtensionModule(modId),
                    (SipBundleDescriptor) descriptor);
            }
        }

        return true;
    }
}
