/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright (c) Ericsson AB, 2004-2007. All rights reserved.
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 */
package org.jvnet.glassfish.comms.replication.dialogmgmt;

import org.jvnet.glassfish.comms.replication.sessmgmt.*;
import java.io.*;

/**
 * Class containing the extra parameters for a dialogFragment.
 *
 * Extra parameters are parameters that are likely to change very
 * frequently. Rather than having to serialize the entire dialogFragment state
 * when any of the extra parameters change, the extra parameters are
 * serialized and replicated separately from the dialogFragment's state.
 *
 * When a dialogFragment is deserialized on a replica instance, its state is
 * overlayed with the latest version of the corresponding extra parameters.
 *
 * @author jluehe
 * @author lwhite
 */
public class DialogFragmentExtraParams implements Serializable {
    private static final long serialVersionUID = 1L;

    // used by migration during upgrade
    private transient String currentOwnerInstanceName;
    
    // This is an absolute time
    private transient long expirationTime;

    private transient String dialogFragmentId;

    // FIXME  Is this really not needed
    //private transient int cseq;

    // The associated dialogFragment
    private transient final HADialogFragment dialogFragment;

    // The id of the associated dialogFragment
    private transient String id;

    private transient int hc;

    // For deserialization.
    public DialogFragmentExtraParams() {
        dialogFragment = null;
    }

    /**
     * Constructor
     *
     * @param dialogFragment The associated dialogFragment
     */
    public DialogFragmentExtraParams(HADialogFragment df) {
        this.dialogFragment = df;
        this.id = df.getDialogId();
        this.hc = id.hashCode();
    }

    public String getId() {
        return id;
    }

    public String getCurrentOwnerInstanceName() {
        if (dialogFragment != null) {
            return dialogFragment.getCurrentOwnerInstanceName();
        } else {
            return currentOwnerInstanceName;
        }
    }

    public long getExpirationTime() {
        if (dialogFragment != null) {
            return dialogFragment.getExpirationTime();
        } else {
            return expirationTime;
        }
    }

    public String getDialogFragmentId() {
        if (dialogFragment != null) {
            return dialogFragment.getDialogId();
        } else {
            return dialogFragmentId;
        }
    }

    /*  FIXME Is there no cseq for DialogFragment.
    public int getCseq() {
        if (dialogFragment != null) {
            //return dialogFragment.getCseq();
            return -1; // FIXME
        } else {
            return cseq;
        }
    }
    */

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }

        if (! (obj instanceof DialogFragmentExtraParams)) {
            return false;
        }

        DialogFragmentExtraParams that = (DialogFragmentExtraParams) obj;
        return this.id.equals(that.id);
    }

    public int hashCode() {
        return hc;
    }

    /**
     * @serialData FIXME.  Describe customized data layout.
     * @param oos 
     * @throws java.io.IOException 
     */
    private void writeObject(ObjectOutputStream oos)
            throws IOException {
        oos.writeObject(id);
        oos.writeObject(getCurrentOwnerInstanceName());
        oos.writeLong(getExpirationTime());
        oos.writeObject(getDialogFragmentId());
        //oos.writeInt(getCseq());
    }

    /**
     * @serialData Set hashCode from hashCode of {@link #getId()}.
     * @param in 
     * @throws java.io.IOException 
     * @throws java.lang.ClassNotFoundException 
     */
    private void readObject(ObjectInputStream in)
            throws IOException, ClassNotFoundException {
        id = (String) in.readObject();
        hc = id.hashCode();
        currentOwnerInstanceName = (String) in.readObject();
        expirationTime = in.readLong();
        dialogFragmentId = (String) in.readObject();
        //cseq = in.readInt();
    }
}
