/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright (c) Ericsson AB, 2004-2007. All rights reserved.
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 */
package org.jvnet.glassfish.comms.replication.sessmgmt;

import java.io.*;

/**
 * Class containing the extra parameters for a SipApplicationSession (SAS).
 *
 * Extra parameters are parameters that are likely to change very
 * frequently. Rather than having to serialize the entire SAS state when
 * any of the extra parameters change, the extra parameters are serialized and
 * replicated separately from the session's state.
 *
 * When a SAS is deserialized on a replica instance, its state is overlayed
 * with the latest version of the corresponding extra parameters.
 *
 * @author jluehe
 * @author lwhite
 */
public class SipApplicationSessionExtraParams implements Serializable {
    
    private static final String QUERY_MODE = "query_mode";

    // Must not access directly, call getter instead
    private transient String currentOwnerInstanceName;

    // Must not access directly, call getter instead
    private transient long expirationTime;

    // The associated SipApplicationSession
    private transient final HASipApplicationSession sas;

    // The id of the associated SipApplicationSession
    private transient String id;

    private transient int hc;
    
    private transient String mode;

    /**
     * Constructor
     *
     * @param sas The associated SipApplicationSession
     */
    public SipApplicationSessionExtraParams(HASipApplicationSession sas) {
        this.sas = sas;
        //sas can be null for a criteria object
        if(sas != null) {
            this.id = sas.getId();
            this.hc = id.hashCode();
        }        
    }
    
    static SipApplicationSessionExtraParams createSearchCriteria(String currentOwnerInstanceName) {
        SipApplicationSessionExtraParams queryTemplate = new SipApplicationSessionExtraParams(null);
        queryTemplate.mode = QUERY_MODE;
        queryTemplate.currentOwnerInstanceName = currentOwnerInstanceName;
        return queryTemplate;
    }    

    public String getId() {
        return id;
    }

    public String getCurrentOwnerInstanceName() {
        if (sas != null) {
            return sas.getCurrentOwnerInstanceName();
        } else {
            return currentOwnerInstanceName;
        }
    }

    //we are interpreting this as an absolute time to expire
    public long getExpirationTime() {
        if (sas != null) {
            return sas.getExpirationTime();
        } else {
            return expirationTime;
        }
    }

    public boolean equals(Object obj) {
        //FIXME add the mode aware equals logic
        if (obj == this) {
            return true;
        }

        if (! (obj instanceof SipApplicationSessionExtraParams)) {
            return false;
        }

        SipApplicationSessionExtraParams that =
            (SipApplicationSessionExtraParams) obj;
        return this.id.equals(that.id);
    }

    public int hashCode() {
        if(mode == QUERY_MODE) {
            throw new IllegalStateException("illegal use of criteria extra param");
        }        
        return hc;
    }

    private void writeObject(ObjectOutputStream oos)
            throws IOException {
        oos.writeObject(id);
        oos.writeObject(getCurrentOwnerInstanceName());
        oos.writeLong(getExpirationTime());
    }

    private void readObject(ObjectInputStream in)
            throws IOException, ClassNotFoundException {
        id = (String) in.readObject();
        hc = id.hashCode();
        currentOwnerInstanceName = (String) in.readObject();
        expirationTime = in.readLong();
    }
}
