/*
* The contents of this file are subject to the terms
* of the Common Development and Distribution License
* (the License).  You may not use this file except in
* compliance with the License.
*
* You can obtain a copy of the license at
* https://glassfish.dev.java.net/public/CDDLv1.0.html or
* glassfish/bootstrap/legal/CDDLv1.0.txt.
* See the License for the specific language governing
* permissions and limitations under the License.
*
* When distributing Covered Code, include this CDDL
* Header Notice in each file and include the License file
* at glassfish/bootstrap/legal/CDDLv1.0.txt.
* If applicable, add the following below the CDDL Header,
* with the fields enclosed by brackets [] replaced by
* you own identifying information:
* "Portions Copyrighted [year] [name of copyright owner]"
*
* Copyright (c) Ericsson AB, 2004-2007. All rights reserved.
* Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
*/
package com.ericsson.ssa.config;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;

/**
 *
 * @author elnelbo
 */
public class ConfigRuntimeException extends RuntimeException {
    private List<Throwable> causes;

    /**
     * Creates a new instance of <code>ConfigException</code> without detail message.
     */
    public ConfigRuntimeException() {
    }

    /**
     * Constructs an instance of <code>ConfigException</code> with the specified detail message.
     * @param cause the Throwable causing this Exception.
     */
    public ConfigRuntimeException(Throwable cause) {
        super(cause);      
    }

    /**
     * Constructs an instance of <code>ConfigException</code> with the specified detail message.
     * @param msg the detail message.
     */
    public ConfigRuntimeException(String msg) {
        super(msg);
    }

    /**
     * Constructs an instance of <code>ConfigException</code> with the specified detail message.
     * @param msg the detail message.
     * @param cause the Throwable causing this Exception.
     */
    public ConfigRuntimeException(String msg, Throwable cause) {
        super(msg, cause);
    }

    /**
     * Constructs an instance of <code>ConfigException</code> with the specified detail message.
     * @param causes list of Throwable causing this Exception.
     */
    public ConfigRuntimeException(List<Throwable> aCauses) {
        super();
        causes = aCauses;
    }
    
    /**
     * Constructs an instance of <code>ConfigException</code> with the specified detail message.
     * @param msg the detail message.
     * @param causes list of Throwable causing this Exception.
     */
    public ConfigRuntimeException(String msg, List<Throwable> aCauses) {
        super(msg);
        causes = aCauses;
    }
    
    public void addCause(Throwable cause) {
        if (causes==null) {
            causes=new ArrayList<Throwable>(1);
        }
        causes.add(cause);        
    }
    
    public List<Throwable> getCauses() {
        return causes;
    }
    
    @Override
    public void printStackTrace(PrintStream s) {
        synchronized (s) {
            super.printStackTrace(s);
            if (causes!=null)
            for (Throwable t : causes) {
                s.println("Additional cause: ");
                t.printStackTrace(s);
            }            
        }
    }
    
    @Override
    public void printStackTrace(PrintWriter s) { 
        synchronized (s) {
            super.printStackTrace(s);
            if (causes!=null)
            for (Throwable t : causes) {
                s.println("Additional cause: ");
                t.printStackTrace(s);
            }            
        }
    }    
}
