/*
* The contents of this file are subject to the terms
* of the Common Development and Distribution License
* (the License).  You may not use this file except in
* compliance with the License.
*
* You can obtain a copy of the license at
* https://glassfish.dev.java.net/public/CDDLv1.0.html or
* glassfish/bootstrap/legal/CDDLv1.0.txt.
* See the License for the specific language governing
* permissions and limitations under the License.
*
* When distributing Covered Code, include this CDDL
* Header Notice in each file and include the License file
* at glassfish/bootstrap/legal/CDDLv1.0.txt.
* If applicable, add the following below the CDDL Header,
* with the fields enclosed by brackets [] replaced by
* you own identifying information:
* "Portions Copyrighted [year] [name of copyright owner]"
*
* Copyright (c) Ericsson AB, 2004-2007. All rights reserved.
* Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
*/
package com.ericsson.ssa.config.annotations;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * This annotation indicates that the method annotated is a property setter
 * to be called by Configuration to initialize or update the property with
 * the value of configuration item for the key and node indicted in the
 * annotation. The property may be of any types that takes a String argument in
 * its constructor or a primitive type and their wrapper types.
 * 
 * This annotation only covers to most common and simple cases of configuration.
 * Use the ConfigFactory and Config ConfigChangeListner when this annotation doesn't
 * suffice.
 * 
 * An object bearing this annotation needs to be activated for configuration to
 * let the annotation take effect. Use the ConfigFactory to do so:
 * <p>
 * <code>ConfigFactory.instance().activateConfiguration(configurable);</code>
 * <p>
 * @param node The node under which the Configuration Item is provided.
 * @param key The key to the Configuration Item. Default is the property name as taken from the setter, using JavaBean conventions.
 * @param value The default value to use when the Configuration does not yield a value and the usage == UsagePolicy.DEFAULT
 * @param usage Indicates how the Configuration Item is to be used. 
 * @param update The update policy on when the setter is called. Default is for each change.
 * 
 * @author elnelbo
 */
@Documented
@Retention(value=RetentionPolicy.RUNTIME)
@Target(value=ElementType.METHOD)
public @interface Configuration {
    /** The node under which the Configuration Item is provided.*/
    String node() default "";
    /** The key to the Configuration Item. Default is the property name as 
     * taken from the setter, using JavaBean conventions.*/
    String key() default "";    
    /** The default value to use when the Configuration does not yield a value 
     * and the usage == UsagePolicy.DEFAULT.*/
    String value() default "";
    /** Indicates how the Configuration Item is to be used,<br> 
     * UsagePolicy.FAIL -> will break when item is not provided in the 
     * Configuration, <br>
     * UsagePolicy.WARN -> this will log a warning,<br> 
     * UsagePolicy.IGNORE -> this will ignore,<br> 
     * UsagePolicy.DEFAULT -> use the value argument as default.*/
    UsagePolicy usage() default UsagePolicy.WARN;
    /** The update policy on when the setter is called. Default is for each 
     * change.*/
    UpdatePolicy update() default UpdatePolicy.DYNAMIC;
}
