/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright (c) Ericsson AB, 2004-2007. All rights reserved.
 */
package com.ericsson.ssa.container;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;


/**
 * Help Class for parsing Input Streams
 *
 * @author lmcpepe
 *
 */
public class MessageContent {
    private int bufferSize = 8192;
    private byte[] buffer = new byte[bufferSize];
    private int offset = 0;

    /**
     * Get an input streal
     *
     * @param is
     * @throws IOException
     */
    public MessageContent(InputStream is) throws IOException {
        parseMessageContent(is);
    }

    public void parseMessageContent(InputStream in) throws IOException {
        int toRead = bufferSize;

        do {
            int len;

            if ((len = in.read(buffer, offset, toRead)) < 0) {
                break;
            }

            toRead -= len;
            offset += len;

            if (offset >= bufferSize) {
                bufferSize *= 2;

                byte[] newBuf = new byte[bufferSize];
                System.arraycopy(buffer, 0, newBuf, 0, offset);
                buffer = newBuf;
                toRead = bufferSize - offset;
            }
        } while (true);
    }

    public byte[] getContentAsBytes() {
        return buffer;
    }

    public String getContentAsString() {
        try {
            return new String(buffer, 0, offset, "UTF-8");
        } catch (UnsupportedEncodingException e) {
            return "";
        }
    }

    public int getContentLength() {
        return offset;
    }
}
