/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright (c) Ericsson AB, 2004-2007. All rights reserved.
 */
package com.ericsson.ssa.container;

import com.ericsson.ssa.config.Config;
import com.ericsson.ssa.config.ConfigFactory;
import com.ericsson.ssa.sip.dns.SipTransports;
import com.ericsson.ssa.sip.dns.TargetTuple;
import java.util.HashMap;
import java.util.Map;

/**
 * A SipBindingCtx is a snapshot of sip-listener from config.
 * Or the SipBindingCtx is artificially devised to reflect public bindings or
 * old style configuration.
 * @author ELNELBO
 */
public class SipBindingCtx {
    private static final String SSL ="/Ssl";
    private SipBindingResolver resolver;
    private String context; 
    private Config config = ConfigFactory.getConfig();
    boolean sipListener;
    
    SipBindingCtx(SipBindingResolver aResolver, String aContext, 
            TargetTuple[] aTargetTuples) {
        this(aResolver, aContext, aTargetTuples, true);
    }   
    
    SipBindingCtx(SipBindingResolver aResolver, String aContext, 
            TargetTuple[] aTargetTuples, boolean isSipListener) {
        resolver = aResolver;
        context = aContext;
        sipListener = isSipListener;
        snapshot(aTargetTuples);
    }   
    
    public String getContext() {
        return context;
    }
    
    public String getId() {
        return id;
    }
    
    public TargetTuple[] getTargetTuples() {
        return targetTuples;
    }
    
    public boolean isEnabled() {
        return enabled;        
    }
    
    public String getSSLAttribute(String anAttribute) {
        return sslAttributes.get(anAttribute);
    }
    
    /**
     * Checks whether the SipBindingCtx is still up to date.
     * @return true if SipBindingCtx is still false if still up to date.
     */
    public boolean isStale() {
        return resolver.isStale(this);
    }
    
    public TargetTuple getTargetTupleForProtocol(SipTransports protocol){
        TargetTuple ttOfProto = null;
        
        if (targetTuples!=null) {
            for (TargetTuple tt : targetTuples)  {
                if (tt.getProtocol().ordinal()==protocol.ordinal()) {
                    ttOfProto = tt;
                    break;
                }
            }
        }
        return ttOfProto;
    }
    
    //Snapshot
    private String id;
    private TargetTuple[] targetTuples;
    private boolean enabled;
    private Map<String, String> sslAttributes = new HashMap<String, String>();
    
    private void snapshot(TargetTuple[] aTargetTuples) {
        targetTuples = aTargetTuples;
        id = sipListener ? config.get(context, "Id") : context;
        enabled = sipListener ? Boolean.parseBoolean(config.get(context, "Enabled")) : true;
        
        if(sipListener) {
            String attr = null;
            
            attr = config.get(context+SSL, "CertNickname");
            if (attr!=null) {
                sslAttributes.put("CertNickname", attr);
            }
            attr = config.get(context+SSL, "Ssl2Enabled");
            if (attr!=null) {
                sslAttributes.put("Ssl2Enabled", attr);
            }
            attr = config.get(context+SSL, "Ssl2Ciphers");
            if (attr!=null) {
                sslAttributes.put("Ssl2Ciphers", attr);
            }
            attr = config.get(context+SSL, "Ssl3Enabled");
            if (attr!=null) {
                sslAttributes.put("Ssl3Enabled", attr);
            }
            attr = config.get(context+SSL, "Ssl3TlsCiphers");
            if (attr!=null) {
                sslAttributes.put("Ssl3TlsCiphers", attr);
            }
            attr = config.get(context+SSL, "TlsEnabled");
            if (attr!=null) {
                sslAttributes.put("TlsEnabled", attr);
            }
            attr = config.get(context+SSL, "TlsRollbackEnabled");
            if (attr!=null) {
                sslAttributes.put("TlsRollbackEnabled", attr);
            }
            attr = config.get(context+SSL, "ClientAuthEnabled");
            if (attr!=null) {
                sslAttributes.put("ClientAuthEnabled", attr);
            }
        }
    }
}
