/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright (c) Ericsson AB, 2004-2007. All rights reserved.
 */
package com.ericsson.ssa.container;

import com.ericsson.ssa.sip.Dispatcher;
import com.ericsson.ssa.sip.SipServletRequestImpl;


/**
 *  Error handler that sends back error response if SipParser fails.
 *
 * @author elnsbur, qmaghes
 * @since Apr 11, 2006
 *
 */
public abstract class SipParserErrorHandler {
    private Dispatcher myDispatcher;
    private boolean isErrorResponseEnabled = true;

    public SipParserErrorHandler(Dispatcher disp) {
        myDispatcher = disp;
    }

    public boolean getErrorResponseEnabled() {
        return isErrorResponseEnabled;
    }

    public void setErrorResponseEnabled(boolean isErrorResponseEnabled) {
        this.isErrorResponseEnabled = isErrorResponseEnabled;
    }

    /**
     * Do the actual error handling.
     *
     * @param req
     * @param code
     * @param errorStr
     */
    public abstract void handleError(SipServletRequestImpl req, int code,
        String errorStr);

    protected Dispatcher getMyDispatcher() {
        return myDispatcher;
    }
}
