/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright (c) Ericsson AB, 2004-2007. All rights reserved.
 */
package com.ericsson.ssa.container.deployer;

import org.apache.catalina.Container;
import org.apache.catalina.LifecycleEvent;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Service;
import org.apache.catalina.core.StandardEngine;
import org.apache.catalina.core.StandardHost;
import org.apache.catalina.core.StandardServer;

import java.io.File;
import java.io.IOException;

import java.net.URL;

import java.util.ArrayList;


public class SIPDeployer implements LifecycleListener {
    private StandardHost host = null;

    /**
     * The names of applications that we have auto-deployed (to avoid double
     * deployment attempts).
     */
    protected ArrayList<String> deployed = new ArrayList<String>();

    public SIPDeployer(StandardHost host) {
        this.host = host;
    }

    /**
     * Deploy applications for any directories or WAR files that are found in our
     * "application root" directory.
     */
    protected void deployApps() {
        // Initialize the deployer
        // host.findDeployedApps();
        File appBase = null;
        File file = new File(host.getAppBase());

        if (!file.isAbsolute()) {
            file = new File(System.getProperty("catalina.base"),
                    host.getAppBase());
        }

        try {
            appBase = file.getCanonicalFile();
        } catch (IOException e) {
            appBase = file;
        }

        if (!appBase.exists() || !appBase.isDirectory()) {
            return;
        }

        // Deploy all .war and .sar files that is in the deploy directory of the
        // host
        String[] files = appBase.list();

        for (int i = 0; i < files.length; i++) {
            String deployArchive = files[i];

            if (deployArchive.endsWith(".war") ||
                    deployArchive.endsWith(".sar")) {
                String contextPath = "/" +
                    deployArchive.substring(0, deployArchive.lastIndexOf('.'));

                try {
                    File archive = new File(appBase, deployArchive);
                    URL url = new URL("file", null, archive.getCanonicalPath());
                    url = new URL("jar:" + url.toString() + "!/");
                    // host.install(contextPath, url);
                    // Add this archive to the list of deployed application
                    deployed.add(deployArchive);
                } catch (Throwable t) {
                    // TODO add logging
                    t.printStackTrace();
                }
            }
        }

        deployDirectories(appBase, files);
    }

    /**
     * Deploy a directory under the host's deploy directory.
     *
     * @param appBase
     *           The Host appBase
     * @param files[]
     *           The files to deploy
     */
    protected void deployDirectories(File appBase, String[] files) {
        if (files == null) {
            return;
        }

        for (int i = 0; i < files.length; i++) {
            if (files[i].equalsIgnoreCase("META-INF") ||
                    files[i].equalsIgnoreCase("WEB-INF") ||
                    deployed.contains(files[i])) {
                continue;
            }

            File dir = new File(appBase, files[i]);

            if (dir.isDirectory()) {
                deployed.add(files[i]);

                // Make sure there is an application configuration directory
                // This is needed if the Context appBase is the same as the
                // web server document root to make sure only web applications
                // are deployed and not directories for web space.
                File webInf = new File(dir, "/WEB-INF");

                if (!webInf.exists() || !webInf.isDirectory() ||
                        !webInf.canRead()) {
                    continue;
                }

                // Calculate the context path and make sure it is unique
                String contextPath = "/" + files[i];

                if (files[i].equals("ROOT")) {
                    contextPath = "";
                }

                if (host.findChild(contextPath) != null) {
                    continue;
                }

                // Deploy the application in this directory
                try {
                    URL url = new URL("file", null, dir.getCanonicalPath());

                    // host.install(contextPath, url);
                } catch (Throwable t) {
                    // TODO Add logging
                }
            }
        }
    }

    /**
     * Deploy application
     *
     * @param applicationName
     */
    public void deployApplication(String applicationName) {
        // call host deploy with the application to deploy
        String strAppBase = System.getProperty("catalina.base") + "\\" +
            host.getAppBase();
        String contextPath = "/" +
            applicationName.substring(0, applicationName.lastIndexOf('.'));
        File dir = null;

        try {
            File appBase = new File(strAppBase);
            dir = new File(appBase, applicationName);
        } catch (Exception e) {
            e.printStackTrace();
        }

        try {
            URL url = new URL("file", null, dir.getCanonicalPath());
            url = new URL("jar:" + url.toString() + "!/");

            // host.install(contextPath, url);
        } catch (Throwable t) {
            // TODO add logging
            t.printStackTrace();
        }
    }

    public void lifecycleEvent(LifecycleEvent event) {
        if (event.getSource() instanceof StandardServer &&
                "before_start".equals(event.getType())) {
            StandardServer server = (StandardServer) event.getSource();
            Service[] service = server.findServices();
            StandardEngine engine = (StandardEngine) service[0].getContainer();
            Container[] container = engine.findChildren();
            host = (StandardHost) container[0];

            LifecycleListener[] listener = host.findLifecycleListeners();

            for (int i = 0; i < listener.length; i++) {
                LifecycleListener ll = listener[i];

                if ("org.apache.catalina.startup.HostConfig".equals(
                            ll.getClass().getName())) {
                    host.removeLifecycleListener(ll); //
                }
            }

            host.addLifecycleListener(this);
            ((StandardServer) event.getSource()).removeLifecycleListener(this);

            // registerMBean();
            Container[] children = host.findChildren();
            String debug = "";
        } else if (event.getSource() instanceof StandardHost) {
            String eType = event.getType(); // before_start, start,
                                            // after_start, check,

            if ("start".equals(eType)) {
                deployApps();
            }
        }
    }
}
