/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright (c) Ericsson AB, 2004-2007. All rights reserved.
 */
package com.ericsson.ssa.container.sim;

import com.ericsson.ssa.dd.Servlet;

import java.util.Comparator;


public class ServletStartupOrderComparator implements Comparator<Servlet> {
    public int compare(Servlet lhs, Servlet rhs) {
        Servlet lhsServlet = lhs;
        Servlet rhsServlet = rhs;

        // Compare two servlets for the load on startup value. If both instances
        // are the same,
        // we return 0. However, if both instances are different but both have the
        // same
        // load on stratup value, we cannot return 0 because compare(x,y) must
        // return 0
        // if and only if x.equals(y). So in this case, we will return -1.
        if ((lhsServlet.getLoadOnStartup() <= rhsServlet.getLoadOnStartup()) &&
                (!lhsServlet.equals(rhsServlet))) {
            return -1;
        } else if (lhsServlet.getLoadOnStartup() > rhsServlet.getLoadOnStartup()) {
            return 1;
        }

        return 0;
    }
}
