/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright (c) Ericsson AB, 2004-2007. All rights reserved.
 */
package com.ericsson.ssa.container.sim;

import java.io.IOException;

import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;


public class SipServletFacade implements Servlet {
    private Servlet target;
    private com.ericsson.ssa.dd.Servlet servlet;
    private long invocations;

    public SipServletFacade(Servlet target, com.ericsson.ssa.dd.Servlet servlet) {
        this.target = target;
        this.servlet = servlet;
    }

    public void destroy() {
        target.destroy();
    }

    public ServletConfig getServletConfig() {
        return target.getServletConfig();
    }

    public String getServletInfo() {
        return target.getServletInfo();
    }

    public void init(ServletConfig config) throws ServletException {
        target.init(config);
    }

    public void service(ServletRequest request, ServletResponse response)
        throws ServletException, IOException {
        invocations++;

        /**
         * This is required by RSH. Otherwise, the application(ApplicationDispatcher) receives ClassCastException
         * since the application and the RSH API (common lib) reside in different classloaders.
         */
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        Thread.currentThread()
              .setContextClassLoader(target.getClass().getClassLoader());
        target.service(request, response);
        Thread.currentThread().setContextClassLoader(cl);
    }

    public long getInvocations() {
        return invocations;
    }

    public String getName() {
        return servlet.getServletName();
    }

    public String getDisplayName() {
        return servlet.getDisplayName();
    }

    public Servlet getServletInstance() {
        return target;
    }
}
