/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright (c) Ericsson AB, 2004-2007. All rights reserved.
 */
package com.ericsson.ssa.dd;

import java.util.ArrayList;
import java.util.Hashtable;

import javax.servlet.sip.SipServletRequest;


/**
 * EqualOperand. The EqualOperand operand verify the equality for a particular
 * attribute of the request
 */
public class EqualOperand extends Operand {
    private static final long serialVersionUID = 3258133544273786673L;

    /**
     * Specifies a variable
     */
    private String variable;

    /**
     * Specifies a literal string value that is used to specify rules
     */
    private String value;

    /**
     * Specifies whether the "contains" test is case sensitive or not
     */
    private boolean ignoreCase;

    /**
     *
     *
     *
     */
    public EqualOperand() {
    }

    /**
     * @param var
     * @param value
     * @param ignoreCase
     * @throws SipParserException
     */
    public EqualOperand(String var, String value, boolean ignoreCase)
        throws SipParserException {
        this.variable = var;
        this.value = value;
        this.ignoreCase = ignoreCase;

        if ((var == null) || (value == null)) {
            throw new SipParserException(
                "equals() value/variable must be non-null");
        }

        if (!isVarValueSupported(var, value)) {
            throw new SipParserException("equals() variable=" + var +
                "  value=" + value + ", not supported");
        }
    }

    /**
     * Evaluate the condition
     *
     * @param object
     *        The object to evaluate
     * @return True if the value of the variable equals the specified literal
     *         value
     */
    public boolean evaluate(Object object) {
        SipServletRequest request = (SipServletRequest) object;
        String a = request.getMethod();

        return ignoreCase
        ? this.value.equalsIgnoreCase(getAttributeValue(variable, request))
        : this.value.equals(getAttributeValue(variable, request));
    }

    /**
     * Returns the method session case list
     *
     * @return A hashtable of the method session case
     * @throws SipParserException
     */
    public Hashtable<String, ArrayList<String>> getMethodSessionCaseList()
        throws SipParserException {
        Hashtable<String, ArrayList<String>> equalTable = new Hashtable<String, ArrayList<String>>();

        if (isMethodOrSessionCase(this.variable)) {
            ArrayList<String> values = new ArrayList<String>();
            values.add(this.value);
            equalTable.put(this.variable, values);
        }

        return equalTable;
    }

    /**
     * @return
     */
    public String getVariable() {
        return variable;
    }

    /**
     * @param variable
     */
    public void setVariable(String variable) {
        this.variable = variable;
    }

    /**
     * @return
     */
    public String getValue() {
        return value;
    }

    /**
     * @param value
     */
    public void setValue(String value) {
        if (value.trim().length() == 0) {
            throw new IllegalArgumentException("balba");
        }

        this.value = value;
    }

    /**
     * @return
     */
    public String toString() {
        return "" + this.variable.toString() + " == \"" + value.toString() +
        "\"";
    }

    /**
     *
     * @param ignoreCase
     */
    public void setIgnoreCase(String ignoreCase) {
        this.ignoreCase = Boolean.parseBoolean(ignoreCase);
    }

    /**
     *
     * @return The session case for equal operand
     */
    public boolean isIgnoreCase() {
        return ignoreCase;
    }
}
