/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright (c) Ericsson AB, 2004-2007. All rights reserved.
 */
package com.ericsson.ssa.dd;

import java.util.ArrayList;
import java.util.Hashtable;

import javax.servlet.sip.SipServletRequest;


public class ExistsOperand extends Operand {
    private static final long serialVersionUID = 3256440313395622709L;

    /**
     * Specifies a variable
     */
    private String variable;

    /**
     * Evaluate the condition
     *
     * @param object
     *        The object to evaluate
     * @return True if the specified variable exists
     */
    public boolean evaluate(Object object) {
        String value = getAttributeValue(variable, (SipServletRequest) object);

        return ((value != null) && (value.length() > 0));
    }

    /**
     * Returns the method session case list
     *
     * @return A hashtable of the method session case
     * @throws SipParserException
     */
    public Hashtable<String, ArrayList<String>> getMethodSessionCaseList()
        throws SipParserException {
        throw new UnsupportedOperationException("Method needs implementation");
    }

    /**
     * @return
     */
    public String getVariable() {
        return variable;
    }

    /**
     * @param variable
     */
    public void setVariable(String variable) {
        this.variable = variable;
    }

    /*
     * (non-Javadoc)
     *
     * @see com.ericsson.ssa.dd.Operand#getValue()
     */
    public String getValue() {
        // TODO Auto-generated method stub
        return null;
    }
}
