/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright (c) Ericsson AB, 2004-2007. All rights reserved.
 */
package com.ericsson.ssa.dd;

public class LoginAuthentication extends Enum {
    public static final LoginAuthentication BASIC = new LoginAuthentication(
            "BASIC");
    public static final LoginAuthentication DIGEST = new LoginAuthentication(
            "DIGEST");
    public static final LoginAuthentication CLIENT_CERT = new LoginAuthentication(
            "CLIENT-CERT");
    public static final LoginAuthentication ASSERTED = new LoginAuthentication("P-Asserted");

    private LoginAuthentication(String name) {
        super(name);
    }

    public static boolean contains(String name) {
        return Enum.contains(LoginAuthentication.class, name);
    }

    public static String printNames() {
        return Enum.toString(LoginAuthentication.class);
    }
}
