/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright (c) Ericsson AB, 2004-2007. All rights reserved.
 */
package com.ericsson.ssa.dd;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;


/**
 * A "or" condition is true if at least one of its constituent conditions is
 * true. This operator is evaluated for each element in the condition list.
 */
public class OrOperator extends Operator {
    private static final long serialVersionUID = 3690196533861497137L;

    public boolean evaluate(Object object) {
        for (int i = 0; i < subConditions.size(); i++) {
            if (((Condition) subConditions.get(i)).evaluate(object)) {
                return true;
            }
        }

        return false;
    }

    /**
     * Returns the method session case list
     *
     * @return A hashtable of the method session case
     * @throws SipParserException
     */
    public Hashtable<String, ArrayList<String>> getMethodSessionCaseList()
        throws SipParserException {
        // Acceptable condition:
        // 1) -One method or +
        // 2) -Others are Error cases (Session-case alone)
        Hashtable<String, ArrayList<String>> methodSessioncaseTableResult = new Hashtable<String, ArrayList<String>>();

        // Retrieve the method+sessioncase information from sub subConditions
        // (operator or operand)
        for (int i = 0; i < subConditions.size(); i++) {
            // For each subList of condition we will extract method or
            // session-case in order to analyse it
            Hashtable<String, ArrayList<String>> curMethSessionTable = subConditions.get(i)
                                                                                    .getMethodSessionCaseList();
            Enumeration<String> keysList = curMethSessionTable.keys();

            while (keysList.hasMoreElements()) {
                String curKey = keysList.nextElement();

                if (curKey.equals("request.method")) {
                    // 1) -One method or +
                    ArrayList<String> methodNameList = curMethSessionTable.get(curKey);
                    Iterator<String> methodNameIter = methodNameList.iterator();

                    while (methodNameIter.hasNext()) {
                        String curMethodName = methodNameIter.next();

                        if (methodSessioncaseTableResult.contains(curMethodName)) {
                            ArrayList<String> curSessionCaseList = methodSessioncaseTableResult.get(curMethodName);
                            curSessionCaseList.clear();
                            curSessionCaseList.add(SessionCase.EXTERNAL.toString());
                        } else {
                            ArrayList<String> newNotSpecifySessionCaseList = new ArrayList<String>();
                            newNotSpecifySessionCaseList.add(SessionCase.EXTERNAL.toString());
                            methodSessioncaseTableResult.put(curMethodName,
                                newNotSpecifySessionCaseList);
                        }
                    }
                } else if (curKey.equals("request.session-case")) {
                    // 2) -Others are Error cases (Session-case alone)
                    throw new SipParserException(
                        "OR: Wrong Condition: one session-case must be under a AND condition and associated to a method");
                } else {
                    if (methodSessioncaseTableResult.containsKey(curKey)) {
                        addOnlyNewElementToTheList(curMethSessionTable.get(
                                curKey),
                            methodSessioncaseTableResult.get(curKey));
                    } else {
                        methodSessioncaseTableResult.put(curKey,
                            curMethSessionTable.get(curKey));
                    }
                }
            }
        }

        return methodSessioncaseTableResult;
    }

    /**
     * @return
     */
    public String toString() {
        StringBuffer sb = new StringBuffer();

        for (int i = 0; i < subConditions.size(); i++) {
            if (i > 0) {
                sb.append(" || ");
            }

            sb.append("(" + subConditions.get(i) + ")");
        }

        return sb.toString();
    }
}
