/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright (c) Ericsson AB, 2004-2007. All rights reserved.
 */
package com.ericsson.ssa.dd;

import java.io.Serializable;


public class ResourceReference implements Serializable {
    private static final long serialVersionUID = 3257852060706747188L;

    /**
     * Default value of the res-sharing-scope element is Shareable
     */
    private String sharingScope = SharingScope.SHAREABLE.getName();
    private String name;
    private String type;
    private String authentication;
    private String description;

    /**
     * @return
     */
    public String getName() {
        return name;
    }

    /**
     * @param name
     */
    public void setName(String name) {
        this.name = name;
    }

    /**
     * @return
     */
    public String getType() {
        return type;
    }

    /**
     * @param type
     */
    public void setType(String type) {
        this.type = type;
    }

    /**
     * @return
     */
    public String getAuthentication() {
        return authentication;
    }

    /**
     * @param authentication
     */
    public void setAuthentication(String authentication) {
        if (!AuthenticationType.contains(authentication)) {
            throw new RuntimeException("The value of the authentication type " +
                "(res-auth element) must be of " +
                AuthenticationType.printNames());
        }

        this.authentication = authentication;
    }

    /**
     * @return
     */
    public String getSharingScope() {
        return sharingScope;
    }

    /**
     * @param sharingScope
     */
    public void setSharingScope(String sharingScope) {
        if (!SharingScope.contains(sharingScope)) {
            throw new RuntimeException("The value of the sharing scope must " +
                "be of " + SharingScope.printNames());
        }

        this.sharingScope = sharingScope;
    }

    /**
     * @return
     */
    public String getDescription() {
        return description;
    }

    /**
     * @param description
     */
    public void setDescription(String description) {
        this.description = description;
    }

    /**
     * @param o
     * @return
     */
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }

        if ((o == null) || !(o instanceof ResourceReference)) {
            return false;
        }

        final ResourceReference reference = (ResourceReference) o;

        return (name != null) ? name.equals(reference.name)
                              : (reference.name == null);
    }

    /**
     * @return
     */
    public int hashCode() {
        return ((name != null) ? name.hashCode() : 0);
    }
}
