/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright (c) Ericsson AB, 2004-2007. All rights reserved.
 */
package com.ericsson.ssa.dd;

import java.io.Serializable;


public class SecurityRoleReference implements Serializable {
    private static final long serialVersionUID = 3257570585595950391L;
    private String roleName;
    private String roleLink;
    private String description;

    /**
     *
     *
     *
     */
    public SecurityRoleReference() {
    }

    /**
     * @return
     */
    public String getRoleName() {
        return roleName;
    }

    /**
     * @param roleName
     */
    public void setRoleName(String roleName) {
        if (roleName.equals("*")) {
            throw new RuntimeException("Since the role-name '*' has a " +
                "special meaning for authorization constraints, " +
                "this value is not permitted for the role-name " +
                "of the security-role-ref element.");
        }

        this.roleName = roleName;
    }

    /**
     * @return
     */
    public String getRoleLink() {
        return roleLink;
    }

    /**
     * @param roleLink
     */
    public void setRoleLink(String roleLink) {
        this.roleLink = roleLink;
    }

    /**
     * @return
     */
    public String getDescription() {
        return description;
    }

    /**
     * @param description
     */
    public void setDescription(String description) {
        this.description = description;
    }
}
