/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright (c) Ericsson AB, 2004-2007. All rights reserved.
 */
package com.ericsson.ssa.dd.rules;

import com.ericsson.ssa.dd.Operator;
import com.ericsson.ssa.dd.Pattern;

import com.sun.org.apache.commons.digester.Digester;
import com.sun.org.apache.commons.digester.Rule;


public class SetOperator extends Rule {
    Digester digester = null;

    /**
     * @param digester
     */
    public SetOperator(Digester digester) {
        this.digester = digester;
    }

    /**
     *
     *
     *
     */
    public SetOperator() {
        super();
    }

    public void end(String namespace, String name) throws Exception {
        Object child = digester.peek(0);
        Object parent = digester.peek(1);

        // Just in case if the parent is a Pattern, otherwise
        // ClassNotException thrown.
        if (parent instanceof Pattern) {
            Operator operator = (Operator) child;
            Pattern pattern = (Pattern) parent;
            pattern.addCondition(operator);
        } else {
            Operator operator = (Operator) child;
            Operator parentOperator = (Operator) parent;
            parentOperator.addCondition(operator);
        }
    }
}
