/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright (c) Ericsson AB, 2004-2007. All rights reserved.
 */
package com.ericsson.ssa.sip;

import java.util.regex.Pattern;


/**
 * Validation of call ID. A call id is one or two words separated by @ sign. See rfc 3261 for definition of word
 *
 *
 * @author qmaghes
 *
 */
public class CallIDValidator extends BasicMandatoryHeaderValidator {
    // Regexp that also accepts single quote which is not correct RFC 3261, but is axxepted as
    // rfc4475 (Sip Torture Text messages) allows it.
    private static final String REGEXP_WORD = "[a-zA-Z1234567890\\-.!%*_+`�~()<>:\\\\\\\"/\\[\\]?{}']+";
    private static final String REGEXP_CALLID = "(" + REGEXP_WORD + ")(@" +
        REGEXP_WORD + "){0,1}";
    private Pattern callIDPattern = Pattern.compile(REGEXP_CALLID);

    public CallIDValidator() {
        super(Header.CALL_ID);
    }

    public boolean validate(SipServletMessageImpl message) {
        Header header = message.getRawHeader(Header.CALL_ID);

        if ((header == null) || (header.getValue() == null) ||
                (header.getValue().length() == 0)) {
            return false;
        }

        String value = header.getValue();

        return callIDPattern.matcher(value).matches();
    }
}
