/**
 * Copyright (c) Ericsson AB 2007
 *
 * All Rights Reserved. Reproduction in whole or in part is prohibited
 * without the written consent of the copyright owner.
 *
 * ERICSSON MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF
 * THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
 * TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
 * PARTICULAR PURPOSE, OR NON-INFRINGEMENT. ERICSSON SHALL NOT BE LIABLE FOR
 * ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR
 * DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.
 */
package com.ericsson.ssa.sip;

import java.util.ArrayList;
import java.util.List;


/**
 * Part of the Proxy implementation. There might be several CreatedTargetSet per
 * Proxy.
 *
 * @author ehsroha
 */
public class CreatedTargetSet extends TargetSet {
    private List<TargetSet> _targetSets = new ArrayList<TargetSet>(0);

    /**
     * The constructor of the CreatedTargetSet implementation.
     *
     * @param p
     *           the Proxy this set belongs to
     * @param recurse
     *           whether recurse is enabled or not
     * @param timeout
     *           the timeout for proxing
     */
    public CreatedTargetSet(ProxyImpl p) {
        super(p);
    }

    @Override
    protected List<TargetSet> getTargetSets() {
        return _targetSets;
    }

    public void add(TargetSet t) {
        _targetSets.add(t);
        t.setParent(this);
    }

    public boolean hasNext() {
        return false;
    }

    public void next() {
        // nothing to do
    }

    public SipServletResponseImpl findBestResponse() {
        return null;
    }

    public void proxyTo() throws IllegalStateException {
        throw new IllegalStateException("this target set is only for creation");
    }

    public void cancel() throws IllegalStateException {
        throw new IllegalStateException("this target set is only for creation");
    }

    /**
     * Always return false
     *
     * @return always false
     */
    @Override
    public boolean isStarted() {
        return false;
    }

    /**
     * Always return false
     *
     * @return always false
     */
    @Override
    public boolean getParallel() {
        return false;
    }

    /**
     * Always return false
     *
     * @return always false
     */
    @Override
    public boolean getRecurse() {
        return false;
    }
}
