/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright (c) Ericsson AB, 2004-2007. All rights reserved.
 */
package com.ericsson.ssa.sip;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.UnsupportedEncodingException;

import java.security.Principal;

import java.util.Enumeration;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;

import javax.servlet.RequestDispatcher;
import javax.servlet.ServletInputStream;
import javax.servlet.sip.Address;
import javax.servlet.sip.AuthInfo;
import javax.servlet.sip.B2buaHelper;
import javax.servlet.sip.Parameterable;
import javax.servlet.sip.Proxy;
import javax.servlet.sip.ServletParseException;
import javax.servlet.sip.SipApplicationRoutingDirective;
import javax.servlet.sip.SipApplicationSession;
import javax.servlet.sip.SipServletMessage;
import javax.servlet.sip.SipServletReadOnlyRequest;
import javax.servlet.sip.SipServletRequest;
import javax.servlet.sip.SipServletResponse;
import javax.servlet.sip.SipSession;
import javax.servlet.sip.SipURI;
import javax.servlet.sip.TooManyHopsException;
import javax.servlet.sip.URI;


public class SipServletReadOnlyRequestImpl implements SipServletReadOnlyRequest {
    private SipServletRequestImpl _fascade;

    public SipServletReadOnlyRequestImpl(SipServletRequestImpl req) {
        _fascade = req;
    }

    public Address getPoppedRoute() {
        return _fascade.getPoppedRoute();
    }

    public URI getRequestURI() {
        return (URI) _fascade.getRequestURI().clone();
    }

    public void setRequestURI(URI reqUri) {
        // NOOP
    }

    public void pushRoute(SipURI route) {
        // NOOP
    }

    public void pushRoute(Address a) {
        // NOOP
    }

    public void pushPath(Address a) {
        // NOOP
    }

    public SipServletMessage.HeaderForm getHeaderForm() {
        return _fascade.getHeaderForm();
    }

    public void setHeaderForm(SipServletMessage.HeaderForm form) {
        // NOOP
    }

    public void setRoutingDirective(SipApplicationRoutingDirective directive,
        SipServletRequest origRequest) {
        // NOOP
    }

    public void addParameterableHeader(String name, Parameterable param,
        boolean first) {
        // NOOP
    }

    public Parameterable getParameterableHeader(String name)
        throws ServletParseException {
        return _fascade.getParameterableHeader(name);
    }

    public ListIterator<Parameterable> getParameterableHeaders(String name)
        throws ServletParseException {
        return _fascade.getParameterableHeaders(name);
    }

    public void setParameterableHeader(String name, Parameterable param) {
        //NOOP
    }

    public Object getContent(Class[] classes)
        throws IOException, UnsupportedEncodingException {
        return _fascade.getContent(classes);
    }

    public int getMaxForwards() {
        return _fascade.getMaxForwards();
    }

    public void setMaxForwards(int maxFw) {
        // NOOP
    }

    public void send() throws IOException {
        // NOOP
    }

    public boolean isInitial() {
        return _fascade.isInitial();
    }

    public ServletInputStream getInputStream() throws IOException {
        return null;
    }

    public BufferedReader getReader() throws IOException {
        return null;
    }

    public Proxy getProxy() throws TooManyHopsException {
        return null;
    }

    public Proxy getProxy(boolean create) throws TooManyHopsException {
        return null;
    }

    public SipServletResponse createResponse(int statusCode) {
        return null;
    }

    public SipServletResponse createResponse(int statusCode, String reasonPhrase) {
        return null;
    }

    public SipServletRequest createCancel() throws IllegalStateException {
        return null;
    }

    public Object getAttribute(String name) {
        return _fascade.getAttribute(name);
    }

    public Enumeration<String> getAttributeNames() {
        return _fascade.getAttributeNames();
    }

    public String getCharacterEncoding() {
        return _fascade.getCharacterEncoding();
    }

    public void setCharacterEncoding(String arg0)
        throws UnsupportedEncodingException {
        // NOOP
    }

    public int getContentLength() {
        return _fascade.getContentLength();
    }

    public String getContentType() {
        return _fascade.getContentType();
    }

    public String getParameter(String name) {
        return _fascade.getParameter(name);
    }

    public Enumeration getParameterNames() {
        return _fascade.getParameterNames();
    }

    public String[] getParameterValues(String name) {
        return _fascade.getParameterValues(name);
    }

    public Map getParameterMap() {
        return _fascade.getParameterMap();
    }

    public String getProtocol() {
        return _fascade.getProtocol();
    }

    public String getScheme() {
        return _fascade.getScheme();
    }

    public String getServerName() {
        return _fascade.getServerName();
    }

    public int getServerPort() {
        return _fascade.getServerPort();
    }

    public String getRemoteAddr() {
        return _fascade.getRemoteAddr();
    }

    public String getRemoteHost() {
        return _fascade.getRemoteHost();
    }

    public void setAttribute(String arg0, Object arg1) {
        // NOOP
    }

    public void removeAttribute(String arg0) {
        // NOOP
    }

    public Locale getLocale() {
        return _fascade.getLocale();
    }

    public Enumeration getLocales() {
        return _fascade.getLocales();
    }

    public boolean isSecure() {
        return _fascade.isSecure();
    }

    public RequestDispatcher getRequestDispatcher(String arg0) {
        return null;
    }

    @Deprecated
    public String getRealPath(String arg0) {
        return _fascade.getRealPath(arg0);
    }

    public int getRemotePort() {
        return _fascade.getRemotePort();
    }

    public String getLocalName() {
        return _fascade.getLocalName();
    }

    public String getLocalAddr() {
        return _fascade.getLocalAddr();
    }

    public int getLocalPort() {
        return _fascade.getLocalPort();
    }

    public Address getFrom() {
        return (Address) _fascade.getFrom().clone();
    }

    public Address getTo() {
        return (Address) _fascade.getTo().clone();
    }

    public String getMethod() {
        return _fascade.getMethod();
    }

    public String getHeader(String name) {
        return _fascade.getHeader(name);
    }

    public ListIterator<String> getHeaders(String name) {
        return _fascade.getHeaders(name);
    }

    public Iterator<String> getHeaderNames() {
        return _fascade.getHeaderNames();
    }

    public void setHeader(String name, String value) {
        // NOOP
    }

    public void addHeader(String name, String value) {
        // NOOP
    }

    public void removeHeader(String name) {
        // NOOP
    }

    public Address getAddressHeader(String name) throws ServletParseException {
        Address addr = _fascade.getAddressHeader(name);

        if (addr != null) {
            return (Address) addr.clone();
        }

        return null;
    }

    public ListIterator<Address> getAddressHeaders(String name)
        throws ServletParseException {
        return _fascade.getAddressHeaders(name);
    }

    public void setAddressHeader(String name, Address value) {
        // NOOP
    }

    public void addAddressHeader(String name, Address value, boolean first) {
        // NOOP
    }

    public String getCallId() {
        return _fascade.getCallId();
    }

    public int getExpires() {
        return _fascade.getExpires();
    }

    public void setExpires(int expires) {
        // NOOP
    }

    public byte[] getRawContent() throws IOException {
        return _fascade.getRawContent();
    }

    public Object getContent() throws IOException, UnsupportedEncodingException {
        return _fascade.getContent();
    }

    public void setContent(Object content, String contentType)
        throws UnsupportedEncodingException {
        // NOOP
    }

    public void setContentLength(int length) {
        // NOOP
    }

    public void setContentType(String contentType) {
        // NOOP
    }

    public SipSession getSession() {
        return _fascade.getSession();
    }

    public SipSession getSession(boolean create) {
        return _fascade.getSession(create);
    }

    public SipApplicationSession getApplicationSession() {
        return _fascade.getApplicationSession();
    }

    public SipApplicationSession getApplicationSession(boolean create) {
        return _fascade.getApplicationSession(create);
    }

    public Locale getAcceptLanguage() {
        return _fascade.getAcceptLanguage();
    }

    public Iterator<Locale> getAcceptLanguages() {
        return _fascade.getAcceptLanguages();
    }

    public void setAcceptLanguage(Locale locale) {
        // NOOP
    }

    public void addAcceptLanguage(Locale locale) {
        // NOOP
    }

    public void setContentLanguage(Locale locale) {
        // NOOP
    }

    public Locale getContentLanguage() {
        return _fascade.getContentLanguage();
    }

    public boolean isCommitted() {
        return _fascade.isCommitted();
    }

    public String getRemoteUser() {
        return _fascade.getRemoteUser();
    }

    public boolean isUserInRole(String role) {
        return _fascade.isUserInRole(role);
    }

    public Principal getUserPrincipal() {
        return _fascade.getUserPrincipal();
    }

    public String getTransport() {
        return _fascade.getTransport();
    }

    public String toString() {
        return _fascade.toString();
    }

    public B2buaHelper getB2buaHelper() {
        return _fascade.getB2buaHelper();
    }

    public void addAuthHeader(SipServletResponse arg0, String arg1, String arg2) {
        //no op
    }

    public void addAuthHeader(SipServletResponse arg0, AuthInfo arg1) {
        //no op
    }
}
