/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright (c) Ericsson AB, 2004-2007. All rights reserved.
 */
package com.ericsson.ssa.sip;

import java.io.UnsupportedEncodingException;

import java.net.InetSocketAddress;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;


/**
 * @author ekrigro TODO To change the template for this generated type comment
 *         go to Window - Preferences - Java - Code Style - Code Templates
 */
public class ViaImpl {
    public final static String PARAM_MADDR = "maddr";
    public final static String PARAM_BRANCH = "branch";
    public final static String PARAM_TTL = "ttl";
    public final static String PARAM_RECEIVED = "received";
    public final static String PARAM_RPORT = "rport";
    private String _transport = null;
    private String _host = null;
    private String _protocol = null;
    private int _port = 5060;
    private Map<String, String> _parameters = new HashMap<String, String>();

    public ViaImpl(String protocol, String transport, String host, int port) {
        _protocol = protocol;
        _transport = transport;
        _host = host;
        _port = port;
    }

    public ViaImpl(String protocol, String transport, String host) {
        this(protocol, transport, host, -1);
    }

    public ViaImpl(String header) {
        byte[] via = header.getBytes();
        int offset = 0;
        int slashCnt = 0;
        int colonIndex = -1;
        boolean inIPv6Addr = false;

        for (; (slashCnt < 2) && (offset < via.length); offset++) {
            if (via[offset] == '/') {
                slashCnt++;
            }
        }

        try {
            _transport = new String(via, offset, 3, SipFactoryImpl.SIP_CHARSET);
            offset += 4;

            int semiIndex = offset;
            boolean foundSemi = false;

            for (; semiIndex < via.length; semiIndex++) {
                if (via[semiIndex] == ';') {
                    foundSemi = true;

                    break;
                } else if (!inIPv6Addr && (via[semiIndex] == '[')) {
                    inIPv6Addr = true;
                } else if (inIPv6Addr && (via[semiIndex] == ']')) {
                    inIPv6Addr = false;
                } else if (!inIPv6Addr && (via[semiIndex] == ':')) {
                    colonIndex = semiIndex;
                }
            }

            int endHost = semiIndex;

            if (colonIndex > 0) {
                endHost = colonIndex;

                try {
                    String port = new String(via, colonIndex + 1,
                            semiIndex - (colonIndex + 1),
                            SipFactoryImpl.SIP_CHARSET);
                    _port = Integer.parseInt(port);
                } catch (Exception e) {
                }
            }

            _host = new String(via, offset, endHost - offset,
                    SipFactoryImpl.SIP_CHARSET);

            if (foundSemi) {
                // log.log(Level.FINE,  new String( bytes, offset, (endParamIndex-offset),
                // SipParser.SIP_CHARSET ) );
                // TODO - can be multiple ; separates
                String param = null;
                String value = "";
                int equalIndex = -1;

                for (int i = ++semiIndex; i < via.length; i++) {
                    if (via[i] == ';') {
                        if (equalIndex > 0) { // End - value
                                              // TODO - Maybe should URL decode the string
                            value = new String(via, equalIndex + 1,
                                    i - (equalIndex + 1),
                                    SipFactoryImpl.SIP_CHARSET);
                        } else if (param == null) { // End - Param name
                            param = new String(via, semiIndex, i - semiIndex,
                                    SipFactoryImpl.SIP_CHARSET);
                        }

                        if (param != null) {
                            _parameters.put(param, value);
                        }

                        param = null;
                        value = "";
                        equalIndex = -1;
                        semiIndex = i + 1;
                    } else if (via[i] == '=') {
                        param = new String(via, semiIndex, i - semiIndex,
                                SipFactoryImpl.SIP_CHARSET);
                        equalIndex = i;
                    }
                }

                if (equalIndex > 0) { // End - value
                                      // TODO - Maybe should URL decode the string
                    value = new String(via, equalIndex + 1,
                            via.length - (equalIndex + 1),
                            SipFactoryImpl.SIP_CHARSET);
                } else { // End - Param name
                    param = new String(via, semiIndex, via.length - semiIndex,
                            SipFactoryImpl.SIP_CHARSET);
                }

                _parameters.put(param, value);
            }
        } catch (UnsupportedEncodingException uee) {
        } // C.C.L.
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(SipFactoryImpl.PROTOCOL_LINE);
        sb.append('/');
        sb.append(_transport);
        sb.append(' ');
        sb.append(_host);

        if (_port > -1) {
            sb.append(':');
            sb.append(_port);
        }

        Iterator<String> iter = _parameters.keySet().iterator();

        while (iter.hasNext()) {
            String name = iter.next();
            String value = _parameters.get(name);
            sb.append(';');
            sb.append(name);

            if ((value != null) && (value.length() > 0)) {
                sb.append('=');
                // TODO - DO "" end encoding if needed
                sb.append(value);
            }
        }

        return sb.toString();
    }

    public InetSocketAddress getNextHop() {
        return new InetSocketAddress(_host, _port);
    }

    // public InetSocketAddress getNextHop() { return
    // InetSocketAddress.createUnresolved( _host, _port ); }
    public String getNextTransport() {
        return _transport;
    }

    public String getTransport() {
        return _transport;
    }

    public int getPort() {
        return _port;
    }

    public String getHost() {
        return _host;
    }

    public String getParameter(String param) {
        return _parameters.get(param);
    }

    public String setParameter(String param, String value) {
        return _parameters.put(param, value);
    }
}
