/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright (c) Ericsson AB, 2004-2007. All rights reserved.
 */
package com.ericsson.ssa.sip.dns;

import org.xbill.DNS.SRVRecord;

import java.util.Comparator;


public class SrvComparator implements Comparator {
    private static final int compBEFORE = -1;
    private static final int compEQUAL = 0;
    private static final int compAFTER = 1;

    public SrvComparator() {
    }

    public int compare(Object o1, Object o2) {
        SRVRecord rec1 = (SRVRecord) o1;
        SRVRecord rec2 = (SRVRecord) o2;
        int comparison = comparePriority(rec1, rec2);

        if (comparison != compEQUAL) {
            return comparison;
        }

        comparison = compareWeight(rec1, rec2);

        if (comparison != compEQUAL) {
            return comparison;
        }

        // for records which has the same priority&weight
        // compare hashcode so the sortorder is allways the same
        // otherwise the random distributions of srv records is fucked up
        // due to that the caching is decided to be performed in dnsjava
        return compareHashCode(rec1, rec2);
    }

    public int comparePriority(SRVRecord rec1, SRVRecord rec2) {
        return ((rec1.getPriority() < rec2.getPriority()) ? compBEFORE
                                                          : ((rec1.getPriority() == rec2.getPriority())
        ? compEQUAL : compAFTER));
    }

    public int compareWeight(SRVRecord rec1, SRVRecord rec2) {
        return ((rec1.getWeight() < rec2.getWeight()) ? compBEFORE
                                                      : ((rec1.getWeight() == rec2.getWeight())
        ? compEQUAL : compAFTER));
    }

    public int compareHashCode(SRVRecord rec1, SRVRecord rec2) {
        return ((rec1.hashCode() < rec2.hashCode()) ? compBEFORE
                                                    : ((rec1.hashCode() == rec2.hashCode())
        ? compEQUAL : compAFTER));
    }

    public boolean equals(Object obj) {
        return equals(obj);
    }
}
