/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright (c) Ericsson AB, 2004-2007. All rights reserved.
 */
package com.ericsson.ssa.sip.persistence;

import javax.servlet.http.HttpSessionContext;
import javax.servlet.sip.ConvergedHttpSession;

import org.apache.catalina.session.ManagerBase;
import org.apache.catalina.session.PersistentManagerBase;

import com.ericsson.ssa.sip.ConvergedHttpSessionFacade;
import com.ericsson.ssa.sip.wrapper.WrappedConvergedHttpSession;
import com.ericsson.ssa.utils.objectwrapping.WrapperContext;

/**
 * HttpSession replicated on every out-of-band modification.
 * 
 * @author epkadsz
 */
public class OnModificationReplicatedHttpSession extends WrappedConvergedHttpSession{

	/** Indicating if the local replication should override the context replication flag. */
	private boolean localReplication = false;

	public OnModificationReplicatedHttpSession(ConvergedHttpSession session, WrapperContext context) {
		super(session, context);
	}

	public ReplicationContext getContext() {
		return (ReplicationContext)super.getContext();
	}
	
	/**
	 * {@inheritDoc}
	 */
	@Override
	public void putValue(String arg0, Object arg1) {
		getDelegate().putValue(arg0, arg1);
		saveDelegate();
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void removeAttribute(String arg0) {
		getDelegate().removeAttribute(arg0);
		saveDelegate();
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void removeValue(String arg0) {
		getDelegate().removeValue(arg0);
		saveDelegate();
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void setAttribute(String name, Object arg1) {
		//just to optimize the analysis
		if (localReplication == false) {
			if (name.equals(ReplicationContext.OOB_SHALLOW_REPLICATION_FLAG)) {
				localReplication = true;
				return; // we dont store the flag
			}
		}
		getDelegate().setAttribute(name, arg1);
		saveDelegate();
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void setMaxInactiveInterval(int arg0) {
		getDelegate().setMaxInactiveInterval(arg0);
		saveDelegate();
	}
	
	/**
	 * Replication logic.
	 */
	@ReplicationTrigger(name = "Out of band / Out of tree for HttpSession", info = "Each modification on http is replicated depending on the replication flags.", condition = "")
	private void saveDelegate() {
		if (getContext().isAutoReplicationOn() || localReplication) {
			getContext().incReplications();
			
			ConvergedHttpSessionFacade httpSession = (ConvergedHttpSessionFacade)getDelegate();
			ManagerBase manager = null;
			//manager = httpSession.getManager(); //TODO uncomment when getManager method is there when added by Jan
			
			if (manager instanceof PersistentManagerBase) {
				PersistentManagerBase pmb = (PersistentManagerBase)manager;
				//manager.writeSession(httpSession); //TODO uncomment when method is there when added by Jan
			}
		}
	}
}
