/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright (c) Ericsson AB, 2004-2007. All rights reserved.
 */
package com.ericsson.ssa.sip.persistence;

import javax.servlet.sip.ServletTimer;

import com.ericsson.ssa.sip.SipApplicationSessionImpl;
import com.ericsson.ssa.sip.wrapper.WrappedServletTimer;
import com.ericsson.ssa.utils.objectwrapping.WrapperContext;
import com.ericsson.ssa.utils.objectwrapping.WrapperUtil;

/**
 * Wrapped servlet timer that trigger replication when the timer is canceled.  
 * 
 * @author epkadsz
 * @since 2007 nov 20
 *
 */
public class OnModificationReplicatedServletTimer extends WrappedServletTimer {
	
	/**
	 * This constructor is special since it will trigger replication.
	 * This to ensure any new timers added out of band to be replicated.
	 * 
	 * @param timer the timer instance to be wrapped
	 */
	public OnModificationReplicatedServletTimer(ServletTimer timer, WrapperContext context) {
		super(timer, context);
		saveDelegate();
	}

	public ReplicationContext getContext() {
		return (ReplicationContext)super.getContext();
	}
	
	@Override
	public void cancel() {
		super.cancel();
		saveDelegate();
	}
	
	@ReplicationTrigger(name = "Cancel Timer OOB / OOT ", info = "When timer is cancel it enforces replication.", condition = "")
	private void saveDelegate() {
		if (getContext().isAutoReplicationOn()) {
			getContext().incReplications();
			
			SipApplicationSessionImpl appSession = (SipApplicationSessionImpl)WrapperUtil.unwrap(getApplicationSession());
			PersistenceUtil.getInstance().saveSipApplicationSessionDeeply(appSession);
		}
	}
}
