/**
 * 
 */
package com.ericsson.ssa.sip.persistence;

import static java.lang.annotation.ElementType.TYPE;
import static java.lang.annotation.ElementType.METHOD;
import static java.lang.annotation.ElementType.PARAMETER;
import static java.lang.annotation.ElementType.FIELD;
import static java.lang.annotation.ElementType.LOCAL_VARIABLE;
import static java.lang.annotation.RetentionPolicy.SOURCE;

import java.lang.annotation.Retention;
import java.lang.annotation.Target;

/**
 * Annotation to quick find all replication points.
 * @author epkadsz
 */
@Target({TYPE, METHOD, FIELD, PARAMETER, LOCAL_VARIABLE})
@Retention(SOURCE)
public @interface ReplicationTrigger {
	String name();
	String info();
	String condition();
}
