/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright (c) Ericsson AB, 2004-2007. All rights reserved.
 */
package com.ericsson.ssa.sip.wrapper;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.Principal;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;

import javax.servlet.RequestDispatcher;
import javax.servlet.ServletInputStream;
import javax.servlet.sip.Address;
import javax.servlet.sip.AuthInfo;
import javax.servlet.sip.B2buaHelper;
import javax.servlet.sip.Parameterable;
import javax.servlet.sip.Proxy;
import javax.servlet.sip.ServletParseException;
import javax.servlet.sip.SipApplicationRoutingDirective;
import javax.servlet.sip.SipApplicationSession;
import javax.servlet.sip.SipServletRequest;
import javax.servlet.sip.SipServletResponse;
import javax.servlet.sip.SipSession;
import javax.servlet.sip.SipURI;
import javax.servlet.sip.TooManyHopsException;
import javax.servlet.sip.URI;


import com.ericsson.ssa.utils.objectwrapping.AbstractWrapperObject;
import com.ericsson.ssa.utils.objectwrapping.WrapperContext;

/**
 * Class for wrapping in sip servlet request instances.
 * Every time when accessing methods that returns SIP entities they need to be wrapped.  
 * 
 * @author epkadsz
 * @since 2007 nov 20
 *
 */
public class WrappedSipRequest extends AbstractWrapperObject<SipServletRequest> implements SipServletRequest {

	public WrappedSipRequest(SipServletRequest request, WrapperContext context) {
		super(request, context);
	}
	
	public void addAuthHeader(SipServletResponse chanllengeResponse, String username, String password) {
		getDelegate().addAuthHeader(chanllengeResponse, username, password);
	}

	public void addAuthHeader(SipServletResponse chanllengeResponse, AuthInfo authinfo) {
		getDelegate().addAuthHeader(chanllengeResponse, authinfo);
	}

	public SipServletRequest createCancel() throws IllegalStateException {
		return WrapperFactorySet.wrap(getDelegate().createCancel(), getContext());
	}

	public SipServletResponse createResponse(int statusCode) {
		return WrapperFactorySet.wrap(getDelegate().createResponse(statusCode), getContext());
	}

	public SipServletResponse createResponse(int statusCode, String reasonPhrase) {
		return WrapperFactorySet.wrap(getDelegate().createResponse(statusCode, reasonPhrase), getContext());
	}

	public B2buaHelper getB2buaHelper() {
		return WrapperFactorySet.wrap(getDelegate().getB2buaHelper(), getContext());
	}

	public ServletInputStream getInputStream() throws IOException {
		return getDelegate().getInputStream();
	}

	public int getMaxForwards() {
		return getDelegate().getMaxForwards();
	}

	public Address getPoppedRoute() {
		return getDelegate().getPoppedRoute();
	}

	/**
	 * Proxy is not wrapped since it can not be retrieved after the dialog is confirmed.
	 */
	public Proxy getProxy() throws TooManyHopsException {
		return getDelegate().getProxy();
	}

	/**
	 * Proxy is not wrapped since it can not be retrieved after the dialog is confirmed.
	 */	
	public Proxy getProxy(boolean create) throws TooManyHopsException {
		return getDelegate().getProxy(create);
	}

	public BufferedReader getReader() throws IOException {
		return getDelegate().getReader();
	}

	public URI getRequestURI() {
		return getDelegate().getRequestURI();
	}

	public boolean isInitial() {
		return getDelegate().isInitial();
	}

	public void pushRoute(Address route) {
		getDelegate().pushRoute(route);
	}

	public void pushRoute(SipURI route) {
		getDelegate().pushRoute(route);
	}

	public void send() throws IOException {
		getDelegate().send();		
	}

	public void setMaxForwards(int maxFw) {
		getDelegate().setMaxForwards(maxFw);
	}

	public void setRequestURI(URI reqUri) {
		getDelegate().setRequestURI(reqUri);
	}

	public void setRoutingDirective(SipApplicationRoutingDirective directive, SipServletRequest origRequest) {
		getDelegate().setRoutingDirective(directive, origRequest);		
	}

	public Object getAttribute(String arg0) {
		return getDelegate().getAttribute(arg0);
	}

	public Enumeration getAttributeNames() {
		return getDelegate().getAttributeNames();
	}

	public String getCharacterEncoding() {
		return getDelegate().getCharacterEncoding();
	}

	public int getContentLength() {
		return getDelegate().getContentLength();
	}

	public String getContentType() {
		return getDelegate().getContentType();
	}

	public String getLocalAddr() {
		return getDelegate().getLocalAddr();
	}

	public String getLocalName() {
		return getDelegate().getLocalName();
	}

	public int getLocalPort() {
		return getDelegate().getLocalPort();
	}

	public Locale getLocale() {
		return getDelegate().getLocale();
	}

	public Enumeration getLocales() {
		return getDelegate().getLocales();
	}

	public String getParameter(String arg0) {
		return getDelegate().getParameter(arg0);
	}

	public Map getParameterMap() {
		return getDelegate().getParameterMap();
	}

	public Enumeration getParameterNames() {
		return getDelegate().getParameterNames();
	}

	public String[] getParameterValues(String arg0) {
		return getDelegate().getParameterValues(arg0);
	}

	public String getProtocol() {
		return getDelegate().getProtocol();
	}

	public String getRealPath(String arg0) {
		return getDelegate().getRealPath(arg0);
	}

	public String getRemoteAddr() {
		return getDelegate().getRemoteAddr();
	}

	public String getRemoteHost() {
		return getDelegate().getRemoteHost();
	}

	public int getRemotePort() {
		return getDelegate().getRemotePort();
	}

	public RequestDispatcher getRequestDispatcher(String arg0) {
		return getDelegate().getRequestDispatcher(arg0);
	}

	public String getScheme() {
		return getDelegate().getScheme();
	}

	public String getServerName() {
		return getDelegate().getServerName();
	}

	public int getServerPort() {
		return getDelegate().getServerPort();
	}

	public boolean isSecure() {
		return getDelegate().isSecure();
	}

	public void removeAttribute(String arg0) {
		getDelegate().removeAttribute(arg0);
	}

	public void setAttribute(String arg0, Object arg1) {
		getDelegate().setAttribute(arg0, arg1);
	}

	public void setCharacterEncoding(String arg0) throws UnsupportedEncodingException {
		getDelegate().setCharacterEncoding(arg0);
	}

	public void addAcceptLanguage(Locale locale) {
		getDelegate().addAcceptLanguage(locale);		
	}

	public void addAddressHeader(String name, Address value, boolean first) {
		getDelegate().addAddressHeader(name, value, first);		
	}

	public void addHeader(String name, String value) {
		getDelegate().addHeader(name, value);		
	}

	public void addParameterableHeader(String name, Parameterable param, boolean first) {
		getDelegate().addParameterableHeader(name, param, first);		
	}

	public Locale getAcceptLanguage() {
		return getDelegate().getAcceptLanguage();
	}

	public Iterator<Locale> getAcceptLanguages() {
		return getDelegate().getAcceptLanguages();
	}

	public Address getAddressHeader(String name) throws ServletParseException {
		return getDelegate().getAddressHeader(name);
	}

	public ListIterator<Address> getAddressHeaders(String name) throws ServletParseException {
		return getDelegate().getAddressHeaders(name);
	}

	public SipApplicationSession getApplicationSession() {
		SipApplicationSession as = getDelegate().getApplicationSession();
		if (as != null)
			as = WrapperFactorySet.getSASFactory().wrap(as, getContext()); 
		
		return as;
	}

	public SipApplicationSession getApplicationSession(boolean create) {
		SipApplicationSession as = getDelegate().getApplicationSession(create);
		if (as != null)
			as = WrapperFactorySet.getSASFactory().wrap(as, getContext());
		return null;
	}

	public String getCallId() {
		return getDelegate().getCallId();
	}

	public Object getContent() throws IOException, UnsupportedEncodingException {
		return getDelegate().getContent();
	}

	public Object getContent(Class[] classes) throws IOException, UnsupportedEncodingException {
		return getDelegate().getContent(classes);
	}

	public Locale getContentLanguage() {
		return getDelegate().getContentLanguage();
	}

	public int getExpires() {
		return getDelegate().getExpires();
	}

	public Address getFrom() {
		return getDelegate().getFrom();
	}

	public String getHeader(String name) {
		return getDelegate().getHeader(name);
	}

	public HeaderForm getHeaderForm() {
		return getDelegate().getHeaderForm();
	}

	public Iterator<String> getHeaderNames() {
		return getDelegate().getHeaderNames();
	}

	public ListIterator<String> getHeaders(String name) {
		return getDelegate().getHeaders(name);
	}

	public String getMethod() {
		return getDelegate().getMethod();
	}

	public Parameterable getParameterableHeader(String name) throws ServletParseException {
		return getDelegate().getParameterableHeader(name);
	}

	public ListIterator<Parameterable> getParameterableHeaders(String name) throws ServletParseException {
		return getDelegate().getParameterableHeaders(name);
	}

	public byte[] getRawContent() throws IOException {
		return getDelegate().getRawContent();
	}

	public String getRemoteUser() {
		return getDelegate().getRemoteUser();
	}

	public SipSession getSession() {
		SipSession ss = getDelegate().getSession();
		if (ss != null)
			ss = WrapperFactorySet.getSipSessionFactory().wrap(ss, getContext());
		return ss;
	}

	public SipSession getSession(boolean create) {
		SipSession ss = getDelegate().getSession(create);
		if (ss != null)
			ss = WrapperFactorySet.getSipSessionFactory().wrap(ss, getContext());
		
		return ss;
	}

	public Address getTo() {
		return getDelegate().getTo();
	}

	public String getTransport() {
		return getDelegate().getTransport();
	}

	public Principal getUserPrincipal() {
		return getDelegate().getUserPrincipal();
	}

	public boolean isCommitted() {
		return getDelegate().isCommitted();
	}

	public boolean isUserInRole(String role) {
		return getDelegate().isUserInRole(role);
	}

	public void removeHeader(String name) {
		getDelegate().removeHeader(name);
	}

	public void setAcceptLanguage(Locale locale) {
		getDelegate().setAcceptLanguage(locale);
	}

	public void setAddressHeader(String name, Address value) {
		getDelegate().setAddressHeader(name, value);
	}

	public void setContent(Object content, String contentType) throws UnsupportedEncodingException {
		getDelegate().setContent(content, contentType);		
	}

	public void setContentLanguage(Locale locale) {
		getDelegate().setContentLanguage(locale);
	}

	public void setContentLength(int len) {
		getDelegate().setContentLength(len);
	}

	public void setContentType(String type) {
		getDelegate().setContentType(type);
		
	}

	public void setExpires(int expires) {
		getDelegate().setExpires(expires);
	}

	public void setHeader(String name, String value) {
		getDelegate().setHeader(name, value);
	}

	public void setHeaderForm(HeaderForm form) {
		getDelegate().setHeaderForm(form);
	}

	public void setParameterableHeader(String name, Parameterable param) {
		getDelegate().setParameterableHeader(name, param);
	}

	public void pushPath(Address path) {
		getDelegate().pushPath(path);
	}
}
