/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright (c) Ericsson AB, 2004-2007. All rights reserved.
 */
package com.ericsson.ssa.sip.wrapper;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.security.Principal;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Locale;

import javax.servlet.ServletOutputStream;
import javax.servlet.sip.Address;
import javax.servlet.sip.Parameterable;
import javax.servlet.sip.Proxy;
import javax.servlet.sip.Rel100Exception;
import javax.servlet.sip.ServletParseException;
import javax.servlet.sip.SipApplicationSession;
import javax.servlet.sip.SipServletRequest;
import javax.servlet.sip.SipServletResponse;
import javax.servlet.sip.SipSession;


import com.ericsson.ssa.utils.objectwrapping.AbstractWrapperObject;
import com.ericsson.ssa.utils.objectwrapping.WrapperContext;

/**
 * TODO Add comments (class description)  
 *  
 * 
 * @author epkadsz
 * @since 2007 nov 20
 *
 */
public class WrappedSipResponse extends AbstractWrapperObject<SipServletResponse> implements SipServletResponse {

	public WrappedSipResponse(SipServletResponse response, WrapperContext context) {
		super(response, context);
	}

	public SipServletRequest createAck() {
		return WrapperFactorySet.getSipRequestFactory().wrap(getDelegate().createAck(), getContext());
	}

	public SipServletRequest createPrack() throws Rel100Exception {
		return WrapperFactorySet.getSipRequestFactory().wrap(getDelegate().createPrack(), getContext());
	}

	public String[] getChallengeRealm() {
		return getDelegate().getChallengeRealm();
	}

	public ServletOutputStream getOutputStream() throws IOException {
		return getDelegate().getOutputStream();
	}

	/**
	 * Proxy is not wrapped.
	 */
	public Proxy getProxy() {
		return getDelegate().getProxy();
	}

	public String getReasonPhrase() {
		return getDelegate().getReasonPhrase();
	}

	public SipServletRequest getRequest() {
		return WrapperFactorySet.getSipRequestFactory().wrap(getDelegate().getRequest(), getContext());
	}

	public int getStatus() {
		return getDelegate().getStatus();
	}

	public PrintWriter getWriter() throws IOException {
		return getDelegate().getWriter();
	}

	public void send() throws IOException {
		getDelegate().send();		
	}

	public void sendReliably() throws Rel100Exception {
		getDelegate().sendReliably();
	}

	public void setStatus(int responseCode) {
		getDelegate().setStatus(responseCode);
	}

	public void setStatus(int responseCode, String reasonPhrase) {
		getDelegate().setStatus(responseCode, reasonPhrase);
	}

	public void flushBuffer() throws IOException {
		getDelegate().flushBuffer();
	}

	public int getBufferSize() {
		return getDelegate().getBufferSize();
	}

	public String getCharacterEncoding() {
		return getDelegate().getCharacterEncoding();
	}

	public String getContentType() {
		return getDelegate().getContentType();
	}

	public Locale getLocale() {
		return getDelegate().getLocale();
	}

	public boolean isCommitted() {
		return getDelegate().isCommitted();
	}

	public void reset() {
		getDelegate().reset();
	}

	public void resetBuffer() {
		getDelegate().resetBuffer();
	}

	public void setBufferSize(int arg0) {
		getDelegate().setBufferSize(arg0);
	}

	public void setCharacterEncoding(String arg0) {
		getDelegate().setCharacterEncoding(arg0);
	}

	public void setContentLength(int arg0) {
		getDelegate().setContentLength(arg0);
	}

	public void setContentType(String arg0) {
		getDelegate().setContentType(arg0);
	}

	public void setLocale(Locale arg0) {
		getDelegate().setLocale(arg0);
	}

	public void addAcceptLanguage(Locale locale) {
		getDelegate().addAcceptLanguage(locale);		
	}

	public void addAddressHeader(String name, Address value, boolean first) {
		getDelegate().addAddressHeader(name, value, first);
	}

	public void addHeader(String name, String value) {
		getDelegate().addHeader(name, value);
	}

	public void addParameterableHeader(String name, Parameterable param, boolean first) {
		getDelegate().addParameterableHeader(name, param, first);
	}

	public Locale getAcceptLanguage() {
		return getDelegate().getAcceptLanguage();
	}

	public Iterator<Locale> getAcceptLanguages() {
		return getDelegate().getAcceptLanguages();
	}

	public Address getAddressHeader(String name) throws ServletParseException {
		return getDelegate().getAddressHeader(name);
	}

	public ListIterator<Address> getAddressHeaders(String name) throws ServletParseException {
		return getDelegate().getAddressHeaders(name);
	}

	public SipApplicationSession getApplicationSession() {
		return WrapperFactorySet.getSASFactory().wrap(getDelegate().getApplicationSession(), getContext());
	}

	public SipApplicationSession getApplicationSession(boolean create) {
		return WrapperFactorySet.getSASFactory().wrap(getDelegate().getApplicationSession(create), getContext());
	}

	public Object getAttribute(String name) {
		return getDelegate().getAttribute(name);
	}

	public Enumeration<String> getAttributeNames() {
		return getDelegate().getAttributeNames();
	}

	public String getCallId() {
		return getDelegate().getCallId();
	}

	public Object getContent() throws IOException, UnsupportedEncodingException {
		return getDelegate().getContent();
	}

	public Object getContent(Class[] classes) throws IOException, UnsupportedEncodingException {
		return getDelegate().getContent(classes);
	}

	public Locale getContentLanguage() {
		return getDelegate().getContentLanguage();
	}

	public int getContentLength() {
		return getDelegate().getContentLength();
	}

	public int getExpires() {
		return getDelegate().getExpires();
	}

	public Address getFrom() {
		return getDelegate().getFrom();
	}

	public String getHeader(String name) {
		return getDelegate().getHeader(name);
	}

	public HeaderForm getHeaderForm() {
		return getDelegate().getHeaderForm();
	}

	public Iterator<String> getHeaderNames() {
		return getDelegate().getHeaderNames();
	}

	public ListIterator<String> getHeaders(String name) {
		return getDelegate().getHeaders(name);
	}

	public String getLocalAddr() {
		return getDelegate().getLocalAddr();
	}

	public int getLocalPort() {
		return getDelegate().getLocalPort();
	}

	public String getMethod() {
		return getDelegate().getMethod();
	}

	public Parameterable getParameterableHeader(String name) throws ServletParseException {
		return getDelegate().getParameterableHeader(name);
	}

	public ListIterator<Parameterable> getParameterableHeaders(String name) throws ServletParseException {
		return getDelegate().getParameterableHeaders(name);
	}

	public String getProtocol() {
		return getDelegate().getProtocol();
	}

	public byte[] getRawContent() throws IOException {
		return getDelegate().getRawContent();
	}

	public String getRemoteAddr() {
		return getDelegate().getRemoteAddr();
	}

	public int getRemotePort() {
		return getDelegate().getRemotePort();
	}

	public String getRemoteUser() {
		return getDelegate().getRemoteUser();
	}

	public SipSession getSession() {
		return WrapperFactorySet.getSipSessionFactory().wrap(getDelegate().getSession(), getContext());
	}

	public SipSession getSession(boolean create) {
		return WrapperFactorySet.getSipSessionFactory().wrap(getDelegate().getSession(create), getContext());
	}

	public Address getTo() {
		return getDelegate().getTo();
	}

	public String getTransport() {
		return getDelegate().getTransport();
	}

	public Principal getUserPrincipal() {
		return getDelegate().getUserPrincipal();
	}

	public boolean isSecure() {
		return getDelegate().isSecure();
	}

	public boolean isUserInRole(String role) {
		return getDelegate().isUserInRole(role);
	}

	public void removeHeader(String name) {
		getDelegate().removeHeader(name);
	}

	public void setAcceptLanguage(Locale locale) {
		getDelegate().setAcceptLanguage(locale);
	}

	public void setAddressHeader(String name, Address value) {
		getDelegate().setAddressHeader(name, value);
	}

	public void setAttribute(String name, Object value) {
		getDelegate().setAttribute(name, value);		
	}

	public void setContent(Object content, String contentType) throws UnsupportedEncodingException {
		getDelegate().setContent(content, contentType);		
	}

	public void setContentLanguage(Locale locale) {
		getDelegate().setContentLanguage(locale);
	}

	public void setExpires(int expires) {
		getDelegate().setExpires(expires);		
	}

	public void setHeader(String name, String value) {
		getDelegate().setHeader(name, value);
	}

	public void setHeaderForm(HeaderForm form) {
		getDelegate().setHeaderForm(form);
	}

	public void setParameterableHeader(String name, Parameterable param) {
		getDelegate().setParameterableHeader(name, param);		
	}
}
