/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright (c) Ericsson AB, 2004-2007. All rights reserved.
 */
package com.ericsson.ssa.utils;

import java.util.StringTokenizer;


/**
 * This is a helper class for parsing different strings.
 *
 * @author edtugdi
 * @since 2005-maj-11
 */
public class ParserHelper {
    /**
     * This method is used for getting the value for a certain parameter
     * @param content - the line to be parsed
     * @param param - parameter to be searched
     * @param delimeter - delimeter
     * @return - the searched value
     */
    public static String getValue(String content, String param, String delimeter) {
        // The parameter can appear in two formats
        // 1. charset="UTF-16", quoted string
        // 2. charset=UTF-16, unquoted string
        StringTokenizer tokens = new StringTokenizer(content, delimeter);
        String value = null;

        while (tokens.hasMoreTokens()) {
            String token = tokens.nextToken();

            if (token.startsWith(param)) {
                value = token.substring(token.indexOf("=") + 1, token.length());

                break;
            }
        }

        if (value != null) {
            String quote = Character.toString('\u0022');

            if (value.startsWith(quote) && value.endsWith(quote)) {
                return value.substring(1, value.length() - 1);
            } else {
                return value;
            }
        }

        return null;
    }

    /**
     * This method is used to replace an existing parameters value with the newvalue
     * @param content - the line to be parsed
     * @param param - parameter to be searched
     * @param newvalue - the new value for the parameter
     * @param delimeter - delimeter
     * @param quoted - if quoted
     * @return the new content with replaced param
     */
    public static String replaceParam(String content, String param,
        String newvalue, String delimeter, boolean quoted) {
        int index = content.indexOf(param);
        int end = -1;
        index = content.indexOf("=", index) + 1;

        if (quoted) {
            index += 1;
            end = content.indexOf("\"", index);
        } else {
            end = content.indexOf(delimeter, index);

            if (end == -1) {
                end = content.indexOf("\"", index);
            }
        }

        String newcontentype = content.substring(0, index);
        newcontentype += newvalue;

        if (end > 0) {
            newcontentype += content.substring(end, content.length());
        }

        return newcontentype;
    }

    /**
     * This method is used for getting the substring of the content.
     * content.substring(0, content.indexOf(delimeter));
     * @param content - the line to be parsed
     * @param delimeter - delimeter
     * @return the string untill the delimeter or null
     */
    public static String getFirstToken(String content, String delimeter) {
        int i = content.indexOf(delimeter);

        if (i > -1) {
            return content.substring(0, i);
        }

        return null;
    }
}
