/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright (c) Ericsson AB, 2004-2007. All rights reserved.
 */
package com.ericsson.ssa.utils.objectwrapping;


/**
 * Abstract implementation as delegate placeholder.   
 *  
 * 
 * @author epkadsz
 * @since 2007 nov 20
 *
 */
public class AbstractWrapperObject<T> implements WrapperObject<T> {

	/**
	 * The underlaying object to delegate all the invocations.
	 */
	private T _delegate;
	
	private WrapperContext _context;
	
	public AbstractWrapperObject(T delegate, WrapperContext context) {
		_delegate = delegate;
		_context = context;
	}
	
	public T getDelegate() {
		return _delegate;
	}

	/**
	 * Equals to ensure that sasOOB.equals(sasIB) returns true.
	 * Observe that the equals will return false if
	 * the comparison is done reversed. Eg sasIB.equals(sasOOB) == false
	 * 
	 * This is one of the sideeffects wrapping objects around where one side is not aware that is can be wrapped.
	 */
	@Override
	public boolean equals(Object obj) {
		return getDelegate().equals(obj);
	}

	@Override
	public String toString() {
		return getDelegate().toString();
	}

	public WrapperContext getContext() {
		return _context;
	}
}
