/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright (c) Ericsson AB, 2004-2007. All rights reserved.
 */
package com.ericsson.ssa.utils.objectwrapping;

import java.util.ListIterator;

/**
 * Extended version of ObjectWrappedIterator  
 *  
 * 
 * @author EPKADSZ
 * @since 2007 nov 22
 *
 */
public class ObjectWrapperListIterator<T> extends ObjectWrapperIterator<T> implements
		ListIterator<T> {

	public ObjectWrapperListIterator(ListIterator<T> list, ObjectWrapper<T> instanceWrapper, WrapperContext context) {
		super(list, instanceWrapper, context);
	}

	public ListIterator<T> getDelegate() {
		return (ListIterator<T>)super.getDelegate();
	}
	
	public void add(T o) {
		getDelegate().add(o);
	}

	public boolean hasPrevious() {
		return getDelegate().hasPrevious();
	}

	public int nextIndex() {
		return getDelegate().nextIndex();
	}

	public T previous() {
		return getInstanceWrapper().wrap(getDelegate().previous(), getContext());
	}

	public int previousIndex() {
		return getDelegate().previousIndex();
	}

	public void set(T o) {
		getDelegate().set(o);
	}

}
