/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright (c) Ericsson AB, 2004-2007. All rights reserved.
 */
package com.ericsson.ssa.utils.objectwrapping;

import java.util.Collection;
import java.util.Iterator;

/**
 * Wrapper collection.
 * 
 * @author EPKADSZ
 * @since 2007 nov 22
 *
 */
public class WrapperCollection<E> extends AbstractWrapperObject<Collection<E>> implements Collection<E> {

	private ObjectWrapper<E> _instanceWrapper;
	
	public WrapperCollection(Collection<E> collection, ObjectWrapper<E> instanceWrapper, WrapperContext context){
		super(collection, context);
		_instanceWrapper = instanceWrapper;
	}
	
	protected ObjectWrapper<E> getInstanceWrapper() {
		return _instanceWrapper;
	}
	
	public boolean add(E o) {
		return getDelegate().add(o);
	}

	public boolean addAll(Collection<? extends E> c) {
		return getDelegate().addAll(c);
	}

	public void clear() {
		getDelegate().clear();
	}

	public boolean contains(Object o) {
		return getDelegate().contains(o);
	}

	public boolean containsAll(Collection<?> c) {
		return getDelegate().containsAll(c);
	}

	public boolean isEmpty() {
		return getDelegate().isEmpty();
	}

	public Iterator<E> iterator() {
		return WrapperUtil.wrap(getDelegate().iterator(), getInstanceWrapper(), getContext());
	}

	public boolean remove(Object o) {
		return getDelegate().remove(o);
	}

	public boolean removeAll(Collection<?> c) {
		return getDelegate().removeAll(c);
	}

	public boolean retainAll(Collection<?> c) {
		return getDelegate().retainAll(c);
	}

	public int size() {
		return getDelegate().size();
	}

	public Object[] toArray() {
		Object[] array = getDelegate().toArray();
		if (array != null && array.length != 0)
		{
			Object[] result = new Object[array.length];
			for (int i = 0; i < array.length; i++)
				result[i] = getInstanceWrapper().wrap((E)array[i], getContext());
			
			return result;
		}
		else
			return array;
	}

	public <E> E[] toArray(E[] a) {
/*		E[] array =_delegate.toArray(a);
		if (array != null && array.length != 0)
		{
			E[] result = (E[])new Object[array.length];
			for (int i = 0; i < array.length; i++)
				result[i] = _instanceWrapper.wrapIn((E)array[i]);

		}*/
		return null;
		
	}
}
