/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright (c) Ericsson AB, 2004-2007. All rights reserved.
 */
package com.ericsson.util.os;

import com.ericsson.util.os.linux.OSUtilLinux;


/**
 * A Factory class for OS specific utilities.
 *
 * @author ehsroha
 * @since 2006-mar-30
 */
public class OSUtilFactory {
    private static final String _osName = System.getProperty("os.name");

    /**
     * Returns a OS util class if the operating system is supported otherwise
     * null.
     *
     * @return a OS util class if the operating system is supported otherwise
     *         null.
     */
    public static OSUtil getOSUtil(String flag) {
        OSUtil osUtil = null;

        if ((flag != null) && (_osName.indexOf("Linux") != -1)) {
            osUtil = new OSUtilLinux();
        } else {
            osUtil = new OSUtilSunspecific();
        }

        return osUtil;
    }
}
