/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright (c) Ericsson AB, 2004-2007. All rights reserved.
 */
package javax.servlet.sip;

import java.io.IOException;
import java.io.UnsupportedEncodingException;

import java.security.Principal;

import java.util.Enumeration;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Locale;


public interface SipServletMessage extends Cloneable {
    Address getFrom();

    Address getTo();

    String getMethod();

    String getProtocol();

    String getHeader(String name);

    ListIterator<String> getHeaders(String name);

    Iterator<String> getHeaderNames();

    void setHeader(String name, String value);

    void addHeader(String name, String value);

    void removeHeader(String name);

    Address getAddressHeader(String name) throws ServletParseException;

    ListIterator<Address> getAddressHeaders(String name)
        throws ServletParseException;

    void setAddressHeader(String name, Address value);

    void addAddressHeader(String name, Address value, boolean first);

    String getCallId();

    int getExpires();

    void setExpires(int expires);

    String getCharacterEncoding();

    void setCharacterEncoding(String encoding)
        throws UnsupportedEncodingException;

    int getContentLength();

    String getContentType();

    byte[] getRawContent() throws IOException;

    Object getContent() throws IOException, UnsupportedEncodingException;

    void setContent(Object content, String contentType)
        throws UnsupportedEncodingException;

    Object getAttribute(String name);

    Enumeration<String> getAttributeNames();

    void setAttribute(String name, Object value);

    SipSession getSession();

    SipSession getSession(boolean create);

    SipApplicationSession getApplicationSession();

    SipApplicationSession getApplicationSession(boolean create);

    void setAcceptLanguage(Locale locale);

    void addAcceptLanguage(Locale locale);

    void setContentLanguage(Locale locale);

    Locale getContentLanguage();

    void send() throws IOException;

    boolean isSecure();

    boolean isCommitted();

    String getRemoteUser();

    boolean isUserInRole(String role);

    Principal getUserPrincipal();

    String getLocalAddr();

    int getLocalPort();

    String getRemoteAddr();

    int getRemotePort();

    String getTransport();

    void addParameterableHeader(String name, Parameterable param, boolean first);

    Iterator<Locale> getAcceptLanguages();

    Locale getAcceptLanguage();

    Object getContent(Class[] classes)
        throws IOException, UnsupportedEncodingException;

    ListIterator<Parameterable> getParameterableHeaders(String name)
        throws ServletParseException;

    Parameterable getParameterableHeader(String name)
        throws ServletParseException;

    void setContentLength(int len);

    void setContentType(String type);

    void setHeaderForm(SipServletMessage.HeaderForm form);

    void setParameterableHeader(String name, Parameterable param);

    HeaderForm getHeaderForm();
    public static enum HeaderForm {COMPACT,
        LONG,
        DEFAULT;
    }
}
