/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright (c) Ericsson AB, 2004-2007. All rights reserved.
 */
package javax.servlet.sip;

import java.util.Iterator;


public interface SipURI extends URI {
    boolean equals(Object o);

    String getUser();

    void setUser(String user);

    String getUserPassword();

    void setUserPassword(String password);

    String getHost();

    void setHost(String host);

    int getPort();

    void setPort(int port);

    boolean isSecure();

    void setSecure(boolean sips);

    String getTransportParam();

    void setTransportParam(String transport);

    String getMAddrParam();

    void setMAddrParam(String mAddr);

    String getMethodParam();

    void setMethodParam(String methodParam);

    int getTTLParam();

    void setTTLParam(int ttl);

    String getUserParam();

    void setUserParam(String userParam);

    boolean getLrParam();

    void setLrParam(boolean lr);

    String getHeader(String name);

    void setHeader(String name, String value);

    // After EDR
    //void removeHeader(String name);
    Iterator<String> getHeaderNames();

    String toString();
}
