/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
 
/**
 *	This generated bean class SipLink matches the DTD element sip-link
 *
 */

package com.sun.enterprise.config.serverbeans;

import org.w3c.dom.*;
import org.netbeans.modules.schema2beans.*;
import java.beans.*;
import java.util.*;
import java.io.Serializable;
import com.sun.enterprise.config.ConfigBean;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.StaleWriteConfigException;
import com.sun.enterprise.util.i18n.StringManager;

// BEGIN_NOI18N

public class SipLink extends ConfigBean implements Serializable
{

	static Vector comparators = new Vector();
	private static final org.netbeans.modules.schema2beans.Version runtimeVersion = new org.netbeans.modules.schema2beans.Version(4, 2, 0);


	public SipLink() {
		this(Common.USE_DEFAULT_VALUES);
	}

	public SipLink(int options)
	{
		super(comparators, runtimeVersion);
		// Properties (see root bean comments for the bean graph)
		initPropertyTables(0);
		this.initialize(options);
	}

	// Setting the default values of the properties
	void initialize(int options) {

	}

	/**
	* Getter for ConnectionAliveTimeoutInSeconds of the Element sip-link
	* @return  the ConnectionAliveTimeoutInSeconds of the Element sip-link
	*/
	public String getConnectionAliveTimeoutInSeconds() {
		return getAttributeValue(ServerTags.CONNECTION_ALIVE_TIMEOUT_IN_SECONDS);
	}
	/**
	* Modify  the ConnectionAliveTimeoutInSeconds of the Element sip-link
	* @param v the new value
	* @throws StaleWriteConfigException if overwrite is false and file changed on disk
	*/
	public void setConnectionAliveTimeoutInSeconds(String v, boolean overwrite) throws StaleWriteConfigException {
		setAttributeValue(ServerTags.CONNECTION_ALIVE_TIMEOUT_IN_SECONDS, v, overwrite);
	}
	/**
	* Modify  the ConnectionAliveTimeoutInSeconds of the Element sip-link
	* @param v the new value
	*/
	public void setConnectionAliveTimeoutInSeconds(String v) {
		setAttributeValue(ServerTags.CONNECTION_ALIVE_TIMEOUT_IN_SECONDS, v);
	}
	/**
	* Get the default value of ConnectionAliveTimeoutInSeconds from dtd
	*/
	public static String getDefaultConnectionAliveTimeoutInSeconds() {
		return "120".trim();
	}
	/**
	* Getter for MaxQueueLength of the Element sip-link
	* @return  the MaxQueueLength of the Element sip-link
	*/
	public String getMaxQueueLength() {
		return getAttributeValue(ServerTags.MAX_QUEUE_LENGTH);
	}
	/**
	* Modify  the MaxQueueLength of the Element sip-link
	* @param v the new value
	* @throws StaleWriteConfigException if overwrite is false and file changed on disk
	*/
	public void setMaxQueueLength(String v, boolean overwrite) throws StaleWriteConfigException {
		setAttributeValue(ServerTags.MAX_QUEUE_LENGTH, v, overwrite);
	}
	/**
	* Modify  the MaxQueueLength of the Element sip-link
	* @param v the new value
	*/
	public void setMaxQueueLength(String v) {
		setAttributeValue(ServerTags.MAX_QUEUE_LENGTH, v);
	}
	/**
	* Get the default value of MaxQueueLength from dtd
	*/
	public static String getDefaultMaxQueueLength() {
		return "50".trim();
	}
	/**
	* Getter for WriteTimeoutInMillis of the Element sip-link
	* @return  the WriteTimeoutInMillis of the Element sip-link
	*/
	public String getWriteTimeoutInMillis() {
		return getAttributeValue(ServerTags.WRITE_TIMEOUT_IN_MILLIS);
	}
	/**
	* Modify  the WriteTimeoutInMillis of the Element sip-link
	* @param v the new value
	* @throws StaleWriteConfigException if overwrite is false and file changed on disk
	*/
	public void setWriteTimeoutInMillis(String v, boolean overwrite) throws StaleWriteConfigException {
		setAttributeValue(ServerTags.WRITE_TIMEOUT_IN_MILLIS, v, overwrite);
	}
	/**
	* Modify  the WriteTimeoutInMillis of the Element sip-link
	* @param v the new value
	*/
	public void setWriteTimeoutInMillis(String v) {
		setAttributeValue(ServerTags.WRITE_TIMEOUT_IN_MILLIS, v);
	}
	/**
	* Get the default value of WriteTimeoutInMillis from dtd
	*/
	public static String getDefaultWriteTimeoutInMillis() {
		return "10".trim();
	}
	/**
	* Getter for WriteTimeoutRetries of the Element sip-link
	* @return  the WriteTimeoutRetries of the Element sip-link
	*/
	public String getWriteTimeoutRetries() {
		return getAttributeValue(ServerTags.WRITE_TIMEOUT_RETRIES);
	}
	/**
	* Modify  the WriteTimeoutRetries of the Element sip-link
	* @param v the new value
	* @throws StaleWriteConfigException if overwrite is false and file changed on disk
	*/
	public void setWriteTimeoutRetries(String v, boolean overwrite) throws StaleWriteConfigException {
		setAttributeValue(ServerTags.WRITE_TIMEOUT_RETRIES, v, overwrite);
	}
	/**
	* Modify  the WriteTimeoutRetries of the Element sip-link
	* @param v the new value
	*/
	public void setWriteTimeoutRetries(String v) {
		setAttributeValue(ServerTags.WRITE_TIMEOUT_RETRIES, v);
	}
	/**
	* Get the default value of WriteTimeoutRetries from dtd
	*/
	public static String getDefaultWriteTimeoutRetries() {
		return "25".trim();
	}
	/**
	* get the xpath representation for this element
	* returns something like abc[@name='value'] or abc
	* depending on the type of the bean
	*/
	protected String getRelativeXPath() {
	    String ret = null;
	    ret = "sip-link";
	    return (null != ret ? ret.trim() : null);
	}

	/*
	* generic method to get default value from dtd
	*/
	public static String getDefaultAttributeValue(String attr) {
		if(attr == null) return null;
		attr = attr.trim();
		if(attr.equals(ServerTags.CONNECTION_ALIVE_TIMEOUT_IN_SECONDS)) return "120".trim();
		if(attr.equals(ServerTags.MAX_QUEUE_LENGTH)) return "50".trim();
		if(attr.equals(ServerTags.WRITE_TIMEOUT_IN_MILLIS)) return "10".trim();
		if(attr.equals(ServerTags.WRITE_TIMEOUT_RETRIES)) return "25".trim();
	return null;
	}
	//
	public static void addComparator(org.netbeans.modules.schema2beans.BeanComparator c) {
		comparators.add(c);
	}

	//
	public static void removeComparator(org.netbeans.modules.schema2beans.BeanComparator c) {
		comparators.remove(c);
	}
	public void validate() throws org.netbeans.modules.schema2beans.ValidateException {
	}

	// Dump the content of this bean returning it as a String
	public void dump(StringBuffer str, String indent){
		String s;
		Object o;
		org.netbeans.modules.schema2beans.BaseBean n;
	}
	public String dumpBeanNode(){
		StringBuffer str = new StringBuffer();
		str.append("SipLink\n");	// NOI18N
		this.dump(str, "\n  ");	// NOI18N
		return str.toString();
	}}

// END_NOI18N

