/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common Development
 * and Distribution License("CDDL") (collectively, the "License").  You
 * may not use this file except in compliance with the License. You can obtain
 * a copy of the License at https://glassfish.dev.java.net/public/CDDL+GPL.html
 * or glassfish/bootstrap/legal/LICENSE.txt.  See the License for the specific
 * language governing permissions and limitations under the License.
 *
 * When distributing the software, include this License Header Notice in each
 * file and include the License file at glassfish/bootstrap/legal/LICENSE.txt.
 * Sun designates this particular file as subject to the "Classpath" exception
 * as provided by Sun in the GPL Version 2 section of the License file that
 * accompanied this code.  If applicable, add the following below the License
 * Header, with the fields enclosed by brackets [] replaced by your own
 * identifying information: "Portions Copyrighted [year]
 * [name of copyright owner]"
 *
 * Contributor(s):
 *
 * If you wish your version of this file to be governed by only the CDDL or
 * only the GPL Version 2, indicate your decision by adding "[Contributor]
 * elects to include this software in this distribution under the [CDDL or GPL
 * Version 2] license."  If you don't indicate a single choice of license, a
 * recipient has the option to distribute your version of this file under
 * either the CDDL, the GPL Version 2 or to extend the choice of license to
 * its licensees as provided above.  However, if you add GPL Version 2 code
 * and therefore, elected the GPL Version 2 license, then the option applies
 * only if the new code is made subject to such option by the copyright
 * holder.
 */

package com.sun.extensions.comms;

import com.sun.jbi.jsf.bean.ListBean;
import com.sun.jsftemplating.annotation.Handler;
import com.sun.jsftemplating.layout.descriptors.handler.HandlerContext;
import com.sun.jsftemplating.util.MessageUtil;
import java.util.Map;
import javax.el.ELContext;
import javax.el.ExpressionFactory;
import javax.el.ValueExpression;
import javax.faces.context.FacesContext;

/**
 *
 * @author irfan
 */
public class SipUtilities {
    
    public static final String SIP_MODULE_TYPE =
            "org.jvnet.glassfish.comms.deployment.backend.SipArchiveDeployer";
    public static final String SIP_RESOURCE_BUNDLE = "org.jvnet.glassfish.comms.admin.gui.extensions.resources.Strings";
    
    /** Creates a new instance of SipUtilities */
    public SipUtilities() {
    }
    
    public static SipConfigBean getSipConfigBean() {
        SipConfigBean result = null;
        FacesContext fCtx = FacesContext.getCurrentInstance();
        ELContext elCtx = fCtx.getELContext();
        ExpressionFactory ef = fCtx.getApplication().getExpressionFactory();
        ValueExpression ve =
                ef.createValueExpression(elCtx, "#{SipConfigBean}", ListBean.class);
        result = (SipConfigBean) ve.getValue(elCtx);
        return result;
    }
    
    public static boolean isEnabled() {
        Boolean result = null;
        FacesContext fCtx = FacesContext.getCurrentInstance();
        ELContext elCtx = fCtx.getELContext();
        ExpressionFactory ef = fCtx.getApplication().getExpressionFactory();
        ValueExpression ve =
                ef.createValueExpression(elCtx, "#{SipConfigBean.enabled}", Boolean.class);
        result = (Boolean) ve.getValue(elCtx);
        return result;
    }
    
    /** Sets SIP specific product information attributes */
    @Handler(id="initSipProductInfoAttributes")
    public static void initSipProductInfoAttributes(HandlerContext handlerContext) {
        Map sessionMap = handlerContext.getFacesContext().getExternalContext().getSessionMap();
        
        //Ensure this method is called once per session
        Object initialized = sessionMap.get("_SIP_INFO_SESSION_INITIALIZED");
        if (initialized != null)
            return;
        
        MessageUtil msgUtil = MessageUtil.getInstance();
        
        // Initialize Product Specific Attributes
        sessionMap.put("productImageURL", msgUtil.getMessage(SIP_RESOURCE_BUNDLE, "productImage.URL"));
        int prodImageHeight = 23;
        int prodImageWidth = 422;
        try {
            prodImageWidth = Integer.parseInt(msgUtil.getMessage(SIP_RESOURCE_BUNDLE, "productImage.width"));
            prodImageHeight = Integer.parseInt(msgUtil.getMessage(SIP_RESOURCE_BUNDLE, "productImage.height"));
        } catch (Exception ex) {
            
        }
        sessionMap.put("productImageWidth", prodImageWidth);
        sessionMap.put("productImageHeight", prodImageHeight);
        
        sessionMap.put("loginProductImageURL", msgUtil.getMessage(SIP_RESOURCE_BUNDLE, "login.productImage.URL"));
        int loginProdImageHeight = 40;
        int loginProdImageWidth = 455;
        try {
            loginProdImageWidth = Integer.parseInt(msgUtil.getMessage(SIP_RESOURCE_BUNDLE, "login.productImage.width"));
            loginProdImageHeight = Integer.parseInt(msgUtil.getMessage(SIP_RESOURCE_BUNDLE, "login.productImage.height"));
        } catch (Exception ex) {
            
        }
        sessionMap.put("loginProductImageWidth", loginProdImageWidth);
        sessionMap.put("loginProductImageHeight", loginProdImageHeight);
        
        
        sessionMap.put("fullProductName", msgUtil.getMessage(SIP_RESOURCE_BUNDLE, "productName.full"));
        sessionMap.put("productVersion", msgUtil.getMessage(SIP_RESOURCE_BUNDLE, "product.version"));
        sessionMap.put("loginButtonTooltip", msgUtil.getMessage(SIP_RESOURCE_BUNDLE, "loginButton.tooltip"));
        sessionMap.put("mastHeadDescription", msgUtil.getMessage(SIP_RESOURCE_BUNDLE, "mastHeadDescription"));
        
        sessionMap.put("showLoadBalancer", false);
        
        sessionMap.put("_SIP_INFO_SESSION_INITIALIZED", "TRUE");
    }
}
