/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright (c) Ericsson AB, 2004-2007. All rights reserved.
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 */

package org.jvnet.glassfish.comms.admin.cli.extensions.commands;

import com.sun.enterprise.cli.framework.*;
import com.sun.enterprise.cli.commands.*;
import com.sun.enterprise.admin.common.JMXFileTransfer;
import javax.management.MBeanServerConnection;
import com.sun.enterprise.config.ConfigException;
import com.sun.appserv.management.client.ProxyFactory;
import com.sun.appserv.management.DomainRoot;
import com.sun.appserv.management.config.WebServiceEndpointConfig;
import com.sun.appserv.management.base.UploadDownloadMgr;
import javax.management.ObjectName;
import java.util.Iterator;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;

import java.io.FileNotFoundException;

public class DCRCommand extends S1ASCommand
{
    private static final String DCR_FILE_LOCATION = "dcrfile";
   
    /**
     *  An abstract method that Executes the command
     *  @throws CommandException
     */
    public void runCommand() throws CommandException, CommandValidationException
    {
        validateOptions();
        
        try { 
            // upload the dcr file to the das config directory
            MBeanServerConnection mbsc = getMBeanServerConnection(getHost(), getPort(), 
                                                                  getUser(), getPassword());
            String remoteLocation = uploadFileToServer(mbsc);
            CLILogger.getInstance().printDebugMessage("uploadedFile = " + 
                                            remoteLocation);
            
            // update the converged-lb-policy element with dcrfile attribute
            String objectName = getObjectName();
            Object[] params = getParamsInfo();
            String operationName = getOperationName();
            String[] types = getTypesInfo();

            Object returnValue = mbsc.invoke(new ObjectName(objectName), 
                                             operationName, params, types);
            handleReturnValue(returnValue);
            CLILogger.getInstance().printDetailMessage(getLocalizedString(
                                                       "CommandSuccessful", new Object[] {name}));
        } catch(Exception e) {
            displayExceptionMessage(e);
        }
    }

    /**
     *Uploads file to temp location on server.
     *@throws CommandException
     */
    private String uploadFileToServer(MBeanServerConnection mbsc) 
                        throws CommandException, IOException
    {
        String dcrFileLocation = getOption(DCR_FILE_LOCATION);
        File file = new File(dcrFileLocation);
        if (!file.isFile()) {
            String msg = getLocalizedString("InvalidDcrFile");
            throw new IOException(msg);
        }
        return new JMXFileTransfer(mbsc).uploadFile(dcrFileLocation, "config");
    }
}
